package main.java.com.netdevsdk.demo.playback.config;

import javax.swing.JOptionPane;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_RENDER_SCALE_E;

/**
 * 
 * @introduction Playback render scale
 * @description Support NVR/VMS
 */
public class PlayBackRenderScale {
	
    /**
     * 
     * @introduction Set playback render scale
     * @description Calling the interface of NETDEV_SetRenderScale
     *
     */
	public static void setPlayBackRenderScale() {
	    if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        if(NetDemo.ChannelID == 0){
            JOptionPane.showMessageDialog(null, "Please select an online channel.");
            return;
        }
		int  enRenderScale=NetDemo.jComboBoxPlayBackRenderScale.getSelectedIndex();
		String enRenderScaleString=NetDemo.jComboBoxPlayBackRenderScale.getItemAt(enRenderScale);
		if(enRenderScaleString==null) {
			return;
		}
		switch (enRenderScaleString) {
        case "FULL":
            enRenderScale=NETDEV_RENDER_SCALE_E.NETDEV_RENDER_SCALE_FULL;
            break;
        case "PROPORTION":
            enRenderScale=NETDEV_RENDER_SCALE_E.NETDEV_RENDER_SCALE_PROPORTION;
            break;
        default:
            break;
        }
		boolean bRet=NetDemo.netdevsdk.NETDEV_SetRenderScale(NetDemo.lpPlayHandle,enRenderScale);
		if(bRet) {
			System.out.println("Success");
		}else {
			System.out.println("NETDEV_SetRenderScale, error:" + NetDemo.netdevsdk.NETDEV_GetLastError());
		}
	}
}
