package main.java.com.netdevsdk.demo.playback.play;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;

import javax.swing.JOptionPane;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.demo.util.Common;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_PLAYBACKCOND_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_PLAYBACKINFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_TRANS_PROTOCAL_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_VIDEO_CODE_TYPE_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_VOD_PLAY_CTRL_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_VOD_PLAY_STATUS_E;

/**
 * 
 * @introduction PlayBack
 * @description Support NVR/VMS
 */
public class Playback {
    
    /**
     * 
     * @introduction Playback by URL
     * @description  Calling the interface of NETDEV_PlayBackByUrl
     *
     */
    public static void playByURL() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        if(NetDemo.ChannelID == 0) {
            JOptionPane.showMessageDialog(null, "Please select an online channel.");
            return;
        }
        if(NetDemo.RecordTable.getSelectedRow()<0) {
            JOptionPane.showMessageDialog(null, "No file,please choose a file");
            return;
        }  
        if(null != NetDemo.lpPlayHandle) {
            JOptionPane.showMessageDialog(null, "Please stop playing first.");
            return;
        }
        NetDemo.jButtonStopPlayback.setEnabled(true);
        NetDemo.jButtonMic.setVisible(false);
        NetDemo.jSliderLiveMicSound.setVisible(false);
        NetDemo.jLabelLiveSound2.setVisible(false);
        NetDemo.jLableLiveMicSound.setVisible(false);
        NetDemo.jLabelLiveViewStreamUrl.setText(null);
        
        Pointer ReplayUrl=new Memory(260);
        boolean bRet= NetDemo.netdevsdk.NETDEV_GetReplayUrl(NetDemo.lpUserID, NetDemo.ChannelID, 0, ReplayUrl);
        byte[] szReplayUrl=ReplayUrl.getByteArray(0, 260);
        String pszReplayUrl=null;
        try {
            pszReplayUrl=new String(szReplayUrl,"GB2312");
            NetDemo.jLabelLiveViewStreamUrl.setText(pszReplayUrl);
        }catch(UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        
        if(NetDemo.RecordTable.getRowCount()<=0) {
            JOptionPane.showMessageDialog(null, "No file,please a file");
            return;
        }
        int row=NetDemo.RecordTable.getSelectedRow();
        String Beginstr=(String)NetDemo.RecordTable.getValueAt(row, 0);
        String Endstr=(String)NetDemo.RecordTable.getValueAt(row, 1);
        if(bRet) {
            NETDEV_PLAYBACKCOND_S pstPlayBackCond=new NETDEV_PLAYBACKCOND_S();
            pstPlayBackCond.dwChannelID = NetDemo.ChannelID;
            pstPlayBackCond.hPlayWnd = Native.getComponentPointer(NetDemo.panelPlayLabel);
            pstPlayBackCond.tBeginTime = Common.date2TimeStamp(Beginstr, NetDemo.DateFormat);
            pstPlayBackCond.tEndTime = Common.date2TimeStamp(Endstr, NetDemo.DateFormat);
            pstPlayBackCond.dwLinkMode = NETDEV_TRANS_PROTOCAL_E.NETDEV_TRANS_PROTOCAL_TCP;
            NetDemo.lpPlayHandle=NetDemo.netdevsdk.NETDEV_PlayBackByUrl(NetDemo.lpUserID, pszReplayUrl, pstPlayBackCond);
            if(null != NetDemo.lpPlayHandle){
                NetDemo.jSliderPlayBack.setMaximum((int)pstPlayBackCond.tEndTime);
                NetDemo.jSliderPlayBack.setMinimum((int)pstPlayBackCond.tBeginTime);
                NetDemo.jSliderPlayBack.setValue(50);
                NetDemo.lblPlaybackSpeed.setText("1X");
                NetDemo.netdevsdk.NETDEV_SetMuteStatus(NetDemo.lpPlayHandle,1);
                NetDemo.netdevsdk.NETDEV_OpenSound(NetDemo.lpPlayHandle);
                Thread singlePlayBackByURLThread=new Thread(new Runnable() {
                    @Override
                    public void run() {
                        int nCount = 0;
                        while(true)
                        {
                            /* 获取窗口码率 */
                            IntByReference pdwBitRate = new IntByReference();
                            boolean bRetBit = NetDemo.netdevsdk.NETDEV_GetBitRate(NetDemo.lpPlayHandle,pdwBitRate);
                            if(bRetBit != true)
                            {
                                System.out.printf("NETDEV_GetBitRate failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                                return;
                            }
                            NetDemo.jLabelBitRateParam.setText(String.valueOf(pdwBitRate.getValue()));
                            
                            /* 获取窗口帧率 */
                            IntByReference pdwFrameRate = new IntByReference();
                            boolean bRet2 = NetDemo.netdevsdk.NETDEV_GetFrameRate(NetDemo.lpPlayHandle,pdwFrameRate);
                            if(bRet2 != true)
                            {
                                System.out.printf("NETDEV_GetFrameRate failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                                return;
                            }
                            NetDemo.jLabelFrameRate.setText(String.valueOf(pdwFrameRate.getValue()));
                            
                            /* 获取窗口编码格式 */
                            IntByReference pdwVideoEncFmt = new IntByReference();
                            boolean bRet3 = NetDemo.netdevsdk.NETDEV_GetVideoEncodeFmt(NetDemo.lpPlayHandle,pdwVideoEncFmt);
                            if(bRet3 != true)
                            {
                                System.out.printf("NETDEV_GetVideoEncodeFmt failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                                return;
                            }
                            String showEncodeFmt=null;
                            if(pdwVideoEncFmt.getValue()==NETDEV_VIDEO_CODE_TYPE_E.NETDEV_VIDEO_CODE_MJPEG){
                                showEncodeFmt="MJPEG";
                            }else if(pdwVideoEncFmt.getValue()==NETDEV_VIDEO_CODE_TYPE_E.NETDEV_VIDEO_CODE_H264) {
                                showEncodeFmt="H.264";
                            }else if(pdwVideoEncFmt.getValue()==NETDEV_VIDEO_CODE_TYPE_E.NETDEV_VIDEO_CODE_H265) {
                                showEncodeFmt="H.265";
                            }
                            NetDemo.jLabelVideoEncodeFmt.setText(showEncodeFmt);
                            
                            /* 获取视频分辨率 */
                            IntByReference pdwWidth = new IntByReference();
                            IntByReference pdwHeight = new IntByReference();
                            boolean bRet4 = NetDemo.netdevsdk.NETDEV_GetResolution(NetDemo.lpPlayHandle,pdwWidth,pdwHeight);
                            if(bRet4 != true)
                            {
                                System.out.printf("NETDEV_GetResolution failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                                return;
                            }
                            NetDemo.jLabelGetpdwWidth.setText(String.valueOf(pdwWidth.getValue())+"x");
                            NetDemo.jLabelGetpdwHeight.setText(String.valueOf(pdwHeight.getValue()));


                            /* 获取窗口丢包率 */
                            IntByReference pURLReceivePacketNum = new IntByReference();
                            IntByReference pURLLostPktNum = new IntByReference();
                            boolean bRet5 = NetDemo.netdevsdk.NETDEV_GetLostPacketRate(NetDemo.lpPlayHandle,pURLReceivePacketNum,pURLLostPktNum);
                            if(bRet5 != true)
                            {
                                System.out.printf("NETDEV_GetLostPacketRate failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                                return;
                            }
                            double lostPacketRate=0.0;
                            if(pURLLostPktNum.getValue()==0) {
                                lostPacketRate=0.0;
                            }else {
                                BigDecimal receive=new BigDecimal(pURLReceivePacketNum.getValue());
                                BigDecimal lost=new BigDecimal(pURLLostPktNum.getValue());
                                BigDecimal sum=receive.add(lost);
                                try {
                                    BigDecimal result=receive.divide(sum,2,BigDecimal.ROUND_HALF_UP);
                                    lostPacketRate=result.doubleValue();
                                } catch (Exception e) {                                  
                                    return;
                                }
                            }
                            NetDemo.jLabelGetpulRecvPktNum.setText(String.valueOf(lostPacketRate));

                            /* 获取静音状态 */
                            IntByReference pbMute=new IntByReference();
                            boolean bRet6= NetDemo.netdevsdk.NETDEV_GetMuteStatus(NetDemo.lpPlayHandle, pbMute);
                            if(!bRet6) {
                                System.out.printf("NETDEV_GetMuteStatus failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                                return;
                            }
                            NetDemo.getMute=pbMute.getValue();
                            
                            /* 控制录像回放的状态 */
                            LongByReference PlayTime = new LongByReference();
                            boolean bRet = NetDemo.netdevsdk.NETDEV_PlayBackControl(NetDemo.lpPlayHandle, NETDEV_VOD_PLAY_CTRL_E.NETDEV_PLAY_CTRL_GETPLAYTIME, PlayTime);
                            if(bRet){
                                long lTime = PlayTime.getValue();
                                NetDemo.jSliderPlayBack.setValue((int)lTime);
                                long lRemainTime = (long)NetDemo.jSliderPlayBack.getMaximum() - lTime;
                                String strRemainTime = String.valueOf(lRemainTime/60/60) + ":" + String.valueOf((lRemainTime/60)%60) + ":"+ String.valueOf(lRemainTime%60);
                                String strInfo = Common.timeStamp2Date(String.valueOf(lTime), NetDemo.DateFormat);
                                strInfo += " / ";
                                strInfo += strRemainTime;
                                NetDemo.lblProgressLabel.setText(strInfo);
                                nCount = 0;
                            }
                            else{
                                nCount++;
                                System.out.println("Get playback time failed");
                            }
                            if((long)NetDemo.jSliderPlayBack.getMaximum() == PlayTime.getValue() || PlayTime.getValue() > (long)NetDemo.jSliderPlayBack.getMaximum()
                                    || nCount>3){
                                NetDemo.netdevsdk.NETDEV_StopPlayBack(NetDemo.lpPlayHandle);
                                NetDemo.lpPlayHandle = null;
                                break;
                            }
                            try{
                                Thread.sleep(700);
                            }catch(InterruptedException e){
                                e.printStackTrace();
                            }
                        }

                    }
                });
                NetDemo.singleLiveThread.execute(singlePlayBackByURLThread);
            }
        }else {
            System.out.println("NETDEV_GetReplayUrl, error:" + NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }

    
        
    }

    /**
     * 
     * @introduction Playback by name
     * @description  Calling the interface of NETDEV_PlayBackByName
     *
     */
    public static void playByName() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        if(NetDemo.ChannelID == 0) {
            JOptionPane.showMessageDialog(null, "Please select an online channel.");
            return;
        }  
        if(NetDemo.RecordTable.getSelectedRow()<0) {
            JOptionPane.showMessageDialog(null, "No file,please choose a file");
            return;
        } 
        if(null != NetDemo.lpPlayHandle) {
            JOptionPane.showMessageDialog(null, "Please stop playing first.");
            return;
        }
        NetDemo.jButtonStopPlayback.setEnabled(true);
        NetDemo.jButtonMic.setVisible(false);
        NetDemo.jSliderLiveMicSound.setVisible(false);
        NetDemo.jLabelLiveSound2.setVisible(false);
        NetDemo.jLableLiveMicSound.setVisible(false);
        NetDemo.jLabelLiveViewStreamUrl.setText(null);
        NETDEV_PLAYBACKINFO_S pstPlayBackInfo = new NETDEV_PLAYBACKINFO_S();

        int row=NetDemo.RecordTable.getSelectedRow();
        /* 获取文件名 */
        String str=(String)NetDemo.RecordTable.getValueAt(row, 2);
        System.arraycopy(str.getBytes(), 0, pstPlayBackInfo.szName, 0, str.getBytes().length);
        String Beginstr=(String)NetDemo.RecordTable.getValueAt(row, 0);
        String Endstr=(String)NetDemo.RecordTable.getValueAt(row, 1);
        pstPlayBackInfo.tBeginTime =Common.date2TimeStamp(Beginstr, NetDemo.DateFormat);
        pstPlayBackInfo.tEndTime = Common.date2TimeStamp(Endstr, NetDemo.DateFormat);
        pstPlayBackInfo.dwLinkMode = NETDEV_TRANS_PROTOCAL_E.NETDEV_TRANS_PROTOCAL_TCP;
        pstPlayBackInfo.hPlayWnd = Native.getComponentPointer(NetDemo.panelPlayLabel);
        NetDemo.lpPlayHandle = NetDemo.netdevsdk.NETDEV_PlayBackByName(NetDemo.lpUserID, pstPlayBackInfo);
        if(null != NetDemo.lpPlayHandle){
            NetDemo.jSliderPlayBack.setMinimum((int)pstPlayBackInfo.tBeginTime);
            NetDemo.jSliderPlayBack.setMaximum((int)pstPlayBackInfo.tEndTime);
            NetDemo.jSliderPlayBack.setValue(50);
            NetDemo.lblPlaybackSpeed.setText("1X");
            NetDemo.netdevsdk.NETDEV_SetMuteStatus(NetDemo.lpPlayHandle,1);
            NetDemo.netdevsdk.NETDEV_OpenSound(NetDemo.lpPlayHandle);
            Thread singleRecordPlayByNameThread=new Thread(new Runnable() {
                @Override
                public void run() {
                    int nCount = 0;
                    while(true)
                    {
                        IntByReference pdwBitRate = new IntByReference();
                        boolean bRetBit = NetDemo.netdevsdk.NETDEV_GetBitRate(NetDemo.lpPlayHandle,pdwBitRate);
                        if(bRetBit != true)
                        {
                            System.out.printf("NETDEV_GetBitRate failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                            return;
                        }
                        NetDemo.jLabelBitRateParam.setText(String.valueOf(pdwBitRate.getValue()));
                        
                        IntByReference pdwFrameRate = new IntByReference();
                        boolean bRet2 = NetDemo.netdevsdk.NETDEV_GetFrameRate(NetDemo.lpPlayHandle,pdwFrameRate);
                        if(bRet2 != true)
                        {
                            System.out.printf("NETDEV_GetFrameRate failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                            return;
                        }
                        NetDemo.jLabelFrameRate.setText(String.valueOf(pdwFrameRate.getValue()));
                        
                        IntByReference pdwVideoEncFmt = new IntByReference();
                        boolean bRet3 = NetDemo.netdevsdk.NETDEV_GetVideoEncodeFmt(NetDemo.lpPlayHandle,pdwVideoEncFmt);
                        if(bRet3 != true)
                        {
                            System.out.printf("NETDEV_GetVideoEncodeFmt failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                            return;
                        }
                        String showEncodeFmt=null;
                        if(pdwVideoEncFmt.getValue()==NETDEV_VIDEO_CODE_TYPE_E.NETDEV_VIDEO_CODE_MJPEG){
                            showEncodeFmt="MJPEG";
                        }else if(pdwVideoEncFmt.getValue()==NETDEV_VIDEO_CODE_TYPE_E.NETDEV_VIDEO_CODE_H264) {
                            showEncodeFmt="H.264";
                        }else if(pdwVideoEncFmt.getValue()==NETDEV_VIDEO_CODE_TYPE_E.NETDEV_VIDEO_CODE_H265) {
                            showEncodeFmt="H.265";
                        }
                        NetDemo.jLabelVideoEncodeFmt.setText(showEncodeFmt);
                        
                        IntByReference pdwWidth = new IntByReference();
                        IntByReference pdwHeight = new IntByReference();
                        boolean bRet4 = NetDemo.netdevsdk.NETDEV_GetResolution(NetDemo.lpPlayHandle,pdwWidth,pdwHeight);
                        if(bRet4 != true)
                        {
                            System.out.printf("NETDEV_GetResolution failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                            return;
                        }
                        NetDemo.jLabelGetpdwWidth.setText(String.valueOf(pdwWidth.getValue())+"x");
                        NetDemo.jLabelGetpdwHeight.setText(String.valueOf(pdwHeight.getValue()));
                      
                        IntByReference pURLReceivePacketNum = new IntByReference();
                        IntByReference pURLLostPktNum = new IntByReference();
                        boolean bRet5 = NetDemo.netdevsdk.NETDEV_GetLostPacketRate(NetDemo.lpPlayHandle,pURLReceivePacketNum,pURLLostPktNum);
                        if(bRet5 != true)
                        {
                            System.out.printf("NETDEV_GetLostPacketRate failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                            return;
                        }
                        double lostPacketRate=0.0;
                        if(pURLLostPktNum.getValue()==0) {
                            lostPacketRate=0.0;
                        }else {
                            BigDecimal receive=new BigDecimal(pURLReceivePacketNum.getValue());
                            BigDecimal lost=new BigDecimal(pURLLostPktNum.getValue());
                            BigDecimal sum=receive.add(lost);
                            try {
                                BigDecimal result=receive.divide(sum,2,BigDecimal.ROUND_HALF_UP);
                                lostPacketRate=result.doubleValue();
                            } catch (Exception e) {                                  
                                return;
                            }
                        }
                        NetDemo.jLabelGetpulRecvPktNum.setText(String.valueOf(lostPacketRate));

                        IntByReference pbMute=new IntByReference();
                        boolean bRet6= NetDemo.netdevsdk.NETDEV_GetMuteStatus(NetDemo.lpPlayHandle, pbMute);
                        if(!bRet6) {
                            System.out.printf("NETDEV_GetMuteStatus failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                            return;
                        }
                        NetDemo.getMute=pbMute.getValue();
                        LongByReference PlayTime = new LongByReference();
                        boolean bRet = NetDemo.netdevsdk.NETDEV_PlayBackControl(NetDemo.lpPlayHandle, NETDEV_VOD_PLAY_CTRL_E.NETDEV_PLAY_CTRL_GETPLAYTIME, PlayTime);
                        if(bRet){
                            long lTime = PlayTime.getValue();
                            NetDemo.jSliderPlayBack.setValue((int)lTime);
                            long lRemainTime = (long)NetDemo.jSliderPlayBack.getMaximum() - lTime;

                            String strRemainTime = String.valueOf(lRemainTime/60/60) + ":" + String.valueOf((lRemainTime/60)%60) + ":"+ String.valueOf(lRemainTime%60);

                            String strInfo = Common.timeStamp2Date(String.valueOf(lTime), NetDemo.DateFormat);
                            strInfo += " / ";
                            strInfo += strRemainTime;
                            NetDemo.lblProgressLabel.setText(strInfo);
                            nCount = 0;
                        }
                        else{
                            nCount++;
                            System.out.println("Get playback time failed");
                        }
                        if((long)NetDemo.jSliderPlayBack.getMaximum() == PlayTime.getValue() || PlayTime.getValue() > (long)NetDemo.jSliderPlayBack.getMaximum()
                                || nCount>3){
                            NetDemo.netdevsdk.NETDEV_StopPlayBack(NetDemo.lpPlayHandle);
                            NetDemo.lpPlayHandle = null;
                            break;
                        }
                        try{
                            Thread.sleep(700);
                        }catch(InterruptedException e){
                            e.printStackTrace();
                        }
                    }
                }
            });
            NetDemo.singleLiveThread.execute(singleRecordPlayByNameThread);
        }
    }

    /**
     * 
     * @introduction Playback by time
     * @description Calling the interface of NETDEV_PlayBackByTime
     *
     */
    public static void playByTime() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        if(NetDemo.ChannelID == 0) {
            JOptionPane.showMessageDialog(null, "Please select an online channel.");
            return;
        }
        if(null != NetDemo.lpPlayHandle) {
            JOptionPane.showMessageDialog(null, "Please stop playing first.");
            return;
        }
        if(NetDemo.RecordTable.getSelectedRow()<0) {
            JOptionPane.showMessageDialog(null, "No file,please choose a file");
            return;
        } 
        NetDemo.jButtonStopPlayback.setEnabled(true);
        NetDemo.jButtonMic.setVisible(false);
        NetDemo.jSliderLiveMicSound.setVisible(false);
        NetDemo.jLabelLiveSound2.setVisible(false);
        NetDemo.jLableLiveMicSound.setVisible(false);
        NetDemo.jLabelLiveViewStreamUrl.setText(null);
        
      //获取选中行
        int row=NetDemo.RecordTable.getSelectedRow(); 
        String Beginstr=(String)NetDemo.RecordTable.getValueAt(row, 0);
        String Endstr=(String)NetDemo.RecordTable.getValueAt(row, 1);
        
        NETDEV_PLAYBACKCOND_S pstPlayBackInfo = new NETDEV_PLAYBACKCOND_S();
        pstPlayBackInfo.dwChannelID = NetDemo.ChannelID;
        pstPlayBackInfo.hPlayWnd = Native.getComponentPointer(NetDemo.panelPlayLabel);
        pstPlayBackInfo.tBeginTime = Common.date2TimeStamp(Beginstr, NetDemo.DateFormat);
        pstPlayBackInfo.tEndTime = Common.date2TimeStamp(Endstr, NetDemo.DateFormat);
        pstPlayBackInfo.dwLinkMode = NETDEV_TRANS_PROTOCAL_E.NETDEV_TRANS_PROTOCAL_TCP;
        
        NetDemo.lpPlayHandle = NetDemo.netdevsdk.NETDEV_PlayBackByTime(NetDemo.lpUserID, pstPlayBackInfo);
        if(null != NetDemo.lpPlayHandle){
            NetDemo.jSliderPlayBack.setMaximum((int)pstPlayBackInfo.tEndTime);
            NetDemo.jSliderPlayBack.setMinimum((int)pstPlayBackInfo.tBeginTime);
            NetDemo.jSliderPlayBack.setValue(50);
            NetDemo.lblPlaybackSpeed.setText("1X");
            NetDemo.netdevsdk.NETDEV_SetMuteStatus(NetDemo.lpPlayHandle,1);
            NetDemo.netdevsdk.NETDEV_OpenSound(NetDemo.lpPlayHandle);
               
            Thread singleRecordPlayThread=new Thread(new Runnable() {
                @Override
                public void run() {
                    int nCount = 0;
                    while(null!=NetDemo.lpPlayHandle) {
                        IntByReference pdwBitRate = new IntByReference();
                        boolean bRetBit = NetDemo.netdevsdk.NETDEV_GetBitRate(NetDemo.lpPlayHandle,pdwBitRate);
                        if(bRetBit != true) {
                            System.out.printf("NETDEV_GetBitRate failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                            return;
                        }
                        NetDemo.jLabelBitRateParam.setText(String.valueOf(pdwBitRate.getValue()));
                        
                        IntByReference pdwFrameRate = new IntByReference();
                        boolean bRet2 = NetDemo.netdevsdk.NETDEV_GetFrameRate(NetDemo.lpPlayHandle,pdwFrameRate);
                        if(bRet2 != true)
                        {
                            System.out.printf("NETDEV_GetFrameRate failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                            return;
                        }
                        NetDemo.jLabelFrameRate.setText(String.valueOf(pdwFrameRate.getValue()));
                        
                        IntByReference pdwVideoEncFmt = new IntByReference();
                        boolean bRet3 = NetDemo.netdevsdk.NETDEV_GetVideoEncodeFmt(NetDemo.lpPlayHandle,pdwVideoEncFmt);
                        if(bRet3 != true)
                        {
                            System.out.printf("NETDEV_GetVideoEncodeFmt failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                            return;
                        }
                        String showEncodeFmt=null;
                        if(pdwVideoEncFmt.getValue()==NETDEV_VIDEO_CODE_TYPE_E.NETDEV_VIDEO_CODE_MJPEG){
                            showEncodeFmt="MJPEG";
                        }else if(pdwVideoEncFmt.getValue()==NETDEV_VIDEO_CODE_TYPE_E.NETDEV_VIDEO_CODE_H264) {
                            showEncodeFmt="H.264";
                        }else if(pdwVideoEncFmt.getValue()==NETDEV_VIDEO_CODE_TYPE_E.NETDEV_VIDEO_CODE_H265) {
                            showEncodeFmt="H.265";
                        }
                        NetDemo.jLabelVideoEncodeFmt.setText(showEncodeFmt);
                        
                        IntByReference pdwWidth = new IntByReference();
                        IntByReference pdwHeight = new IntByReference();
                        boolean bRet4 = NetDemo.netdevsdk.NETDEV_GetResolution(NetDemo.lpPlayHandle,pdwWidth,pdwHeight);
                        if(bRet4 != true)
                        {
                            System.out.printf("NETDEV_GetResolution failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                            return;
                        }
                        NetDemo.jLabelGetpdwWidth.setText(String.valueOf(pdwWidth.getValue())+"x");
                        NetDemo.jLabelGetpdwHeight.setText(String.valueOf(pdwHeight.getValue()));
                        
                        IntByReference pURLReceivePacketNum = new IntByReference();
                        IntByReference pURLLostPktNum = new IntByReference();
                        boolean bRet5 = NetDemo.netdevsdk.NETDEV_GetLostPacketRate(NetDemo.lpPlayHandle,pURLReceivePacketNum,pURLLostPktNum);
                        if(bRet5 != true)
                        {
                            System.out.printf("NETDEV_GetLostPacketRate failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                            return;
                        }
                        double lostPacketRate=0.0;
                        if(pURLLostPktNum.getValue()==0) {
                            lostPacketRate=0.0;
                        }else {
                            BigDecimal receive=new BigDecimal(pURLReceivePacketNum.getValue());
                            BigDecimal lost=new BigDecimal(pURLLostPktNum.getValue());
                            BigDecimal sum=receive.add(lost);
                            try {
                                BigDecimal result=receive.divide(sum,2,BigDecimal.ROUND_HALF_UP);
                                lostPacketRate=result.doubleValue();
                            } catch (Exception e) {                                  
                                return;
                            }
                        }
                        NetDemo.jLabelGetpulRecvPktNum.setText(String.valueOf(lostPacketRate));

                        IntByReference pbMute=new IntByReference();
                        boolean bRet6= NetDemo.netdevsdk.NETDEV_GetMuteStatus(NetDemo.lpPlayHandle, pbMute);
                        if(!bRet6) {
                            System.out.printf("NETDEV_GetMuteStatus failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                            return;
                        }
                        NetDemo.getMute=pbMute.getValue();
                        LongByReference PlayTime = new LongByReference();
                        boolean bRet = NetDemo.netdevsdk.NETDEV_PlayBackControl(NetDemo.lpPlayHandle, NETDEV_VOD_PLAY_CTRL_E.NETDEV_PLAY_CTRL_GETPLAYTIME, PlayTime);
                        if(bRet){
                            long lTime = PlayTime.getValue(); 
                            NetDemo.jSliderPlayBack.setValue((int)lTime);
                            long lRemainTime = (long)NetDemo.jSliderPlayBack.getMaximum() - lTime;
                            String strRemainTime = String.valueOf(lRemainTime/60/60) + ":" + String.valueOf((lRemainTime/60)%60) + ":"+ String.valueOf(lRemainTime%60);
                            String strInfo = Common.timeStamp2Date(String.valueOf(lTime), NetDemo.DateFormat);
                            strInfo += " / ";
                            strInfo += strRemainTime;
                            NetDemo.lblProgressLabel.setText(strInfo);
                            nCount = 0;
                        }
                        else{
                            nCount++;
                            System.out.println("Get playback time failed");
                        }
                        if((long)NetDemo.jSliderPlayBack.getMaximum() == PlayTime.getValue() || PlayTime.getValue() > (long)NetDemo.jSliderPlayBack.getMaximum()
                                || nCount>3){
                            NetDemo.netdevsdk.NETDEV_StopPlayBack(NetDemo.lpPlayHandle);
                            NetDemo.lpPlayHandle = null;
                            break;
                        }
                        try{
                            Thread.sleep(700);
                            }catch(InterruptedException e){
                            e.printStackTrace();
                            }
                        }
                    }
                });
            NetDemo.singleLiveThread.execute(singleRecordPlayThread);
            }    
        }

    /**
     * 
     * @introduction Stop playback
     * @description Calling the interface of NETDEV_StopPlayBack
     *
     */
    public static void stopPlay() {
        if(null != NetDemo.lpPlayHandle){
            NetDemo.netdevsdk.NETDEV_StopPlayBack(NetDemo.lpPlayHandle);
            NetDemo.lpPlayHandle = null;
        }
        NetDemo.jButtonStopPlayback.setEnabled(false);
        NetDemo.panelPlayLabel.repaint();
        NetDemo.jSliderPlayBack.setValue(0);
        NetDemo.jButtonMic.setVisible(true);
        NetDemo.jSliderLiveMicSound.setVisible(true);
        NetDemo.jLabelFrameRate.setText(null);
        NetDemo.jLabelBitRateParam.setText(null);
        NetDemo.jLabelVideoEncodeFmt.setText(null);
        NetDemo.jLabelGetpdwWidth.setText(null);
        NetDemo.jLabelGetpdwHeight.setText(null);
        NetDemo.jLabelGetpulRecvPktNum.setText(null);
        NetDemo.jLabelLiveViewStreamUrl.setText(null);
        NetDemo.lblProgressLabel.setText(null);
        NetDemo.lblPlaybackSpeed.setText("1X");
    }

    /**
     * 
     * @introduction Pause or Resume
     * @description Calling the interface of NETDEV_PlayBackControl
     *
     */
    public static void pauseOrResume() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        if(NETDEV_VOD_PLAY_CTRL_E.NETDEV_PLAY_CTRL_PAUSE == NetDemo.PlayBackControlCmd){
            boolean bRet = NetDemo.netdevsdk.NETDEV_PlayBackControl(NetDemo.lpPlayHandle, NETDEV_VOD_PLAY_CTRL_E.NETDEV_PLAY_CTRL_RESUME, null);
            if(bRet){
                NetDemo.PlayBackControlCmd = NETDEV_VOD_PLAY_CTRL_E.NETDEV_PLAY_CTRL_RESUME;
                NetDemo.jButtonPauseOrResume.setText("pause");
            }
        }
        else{
            boolean bRet = NetDemo.netdevsdk.NETDEV_PlayBackControl(NetDemo.lpPlayHandle, NETDEV_VOD_PLAY_CTRL_E.NETDEV_PLAY_CTRL_PAUSE, null);
            if(bRet){
                NetDemo.PlayBackControlCmd = NETDEV_VOD_PLAY_CTRL_E.NETDEV_PLAY_CTRL_PAUSE;
                NetDemo.jButtonPauseOrResume.setText("Resume");
            }
        }
    }

    /**
     * 
     * @introduction  Drag playback progress bar to change play time 
     * @description
     *
     */
    public static void dragPlaybackSlider() {
        /* 保持拖动进度条前后播放状态相同 */
        if(NETDEV_VOD_PLAY_CTRL_E.NETDEV_PLAY_CTRL_PAUSE == NetDemo.PlayBackControlCmd) {
            LongByReference PlayTime = new LongByReference();
            PlayTime.setValue((long)NetDemo.jSliderPlayBack.getValue());
            boolean bRet = NetDemo.netdevsdk.NETDEV_PlayBackControl(NetDemo.lpPlayHandle, NETDEV_VOD_PLAY_CTRL_E.NETDEV_PLAY_CTRL_SETPLAYTIME, PlayTime);      
            if(!bRet){
                System.out.println("Set playback time failed:" + Common.timeStamp2Date(Long.toString(PlayTime.getValue()), NetDemo.DateFormat));
            }
            boolean bRet1 = NetDemo.netdevsdk.NETDEV_PlayBackControl(NetDemo.lpPlayHandle, NETDEV_VOD_PLAY_CTRL_E.NETDEV_PLAY_CTRL_PAUSE, null);
            if(bRet1){
                NetDemo.PlayBackControlCmd = NETDEV_VOD_PLAY_CTRL_E.NETDEV_PLAY_CTRL_PAUSE;
                NetDemo.jButtonPauseOrResume.setText("Resume");
            }
        }else {
            LongByReference PlayTime = new LongByReference();
            PlayTime.setValue((long)NetDemo.jSliderPlayBack.getValue());
            boolean bRet = NetDemo.netdevsdk.NETDEV_PlayBackControl(NetDemo.lpPlayHandle, NETDEV_VOD_PLAY_CTRL_E.NETDEV_PLAY_CTRL_SETPLAYTIME, PlayTime);      
            if(!bRet){
                System.out.println("Set playback time failed:" + Common.timeStamp2Date(Long.toString(PlayTime.getValue()), NetDemo.DateFormat));
            }
        }
    }

    /**
     * 
     * @introduction Slow the speed of playing playback
     * @description Calling the interface of NETDEV_PlayBackControl
     *
     */
    public static void slowPlaySpeed() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        LongByReference PlaySpeed = new LongByReference();
        boolean bRet = NetDemo.netdevsdk.NETDEV_PlayBackControl(NetDemo.lpPlayHandle, NETDEV_VOD_PLAY_CTRL_E.NETDEV_PLAY_CTRL_GETPLAYSPEED, PlaySpeed);
        if(!bRet){
            System.out.println("Get playback speed failed");
            return;
        }
        long value = PlaySpeed.getValue();
        if(value <= NETDEV_VOD_PLAY_STATUS_E.NETDEV_PLAY_STATUS_16_BACKWARD){
            JOptionPane.showMessageDialog(null, "It's already minimum playback speed.");
            return;
        }
        value -= 1;
        if((value==NETDEV_VOD_PLAY_STATUS_E.NETDEV_PLAY_STATUS_HALF_BACKWARD)||(value==NETDEV_VOD_PLAY_STATUS_E.NETDEV_PLAY_STATUS_QUARTER_BACKWARD)) {
            value-=2;
        }
        PlaySpeed.setValue(value);
         bRet = NetDemo.netdevsdk.NETDEV_PlayBackControl(NetDemo.lpPlayHandle, NETDEV_VOD_PLAY_CTRL_E.NETDEV_PLAY_CTRL_SETPLAYSPEED, PlaySpeed);
        if(!bRet){
            System.out.println("Set playback speed failed:" + value);
        }
        else{
            NetDemo.lblPlaybackSpeed.setText(Common.PlaybackSpeedToLong((int)value));
            System.out.println("Set playback speed success:" + value);
        }
        if(NETDEV_VOD_PLAY_CTRL_E.NETDEV_PLAY_CTRL_PAUSE == NetDemo.PlayBackControlCmd) {
            NetDemo.jButtonPauseOrResume.doClick();
        }
    }
    
    /**
     * 
     * @introduction Fast the speed of playing playback
     * @description  Calling the interface of NETDEV_PlayBackControl
     *
     */
    public static void fastPlaySpeed() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        LongByReference PlaySpeed = new LongByReference();
        boolean bRet = NetDemo.netdevsdk.NETDEV_PlayBackControl(NetDemo.lpPlayHandle, NETDEV_VOD_PLAY_CTRL_E.NETDEV_PLAY_CTRL_GETPLAYSPEED, PlaySpeed);
        if(!bRet){
            System.out.println("Get playback speed failed");
            return;
        }
        long value = PlaySpeed.getValue();
        if(value >= NETDEV_VOD_PLAY_STATUS_E.NETDEV_PLAY_STATUS_16_FORWARD){
            JOptionPane.showMessageDialog(null, "It's already maximum playback speed.");
            return;
        }
        value += 1;
        if((value==NETDEV_VOD_PLAY_STATUS_E.NETDEV_PLAY_STATUS_HALF_BACKWARD)||(value==NETDEV_VOD_PLAY_STATUS_E.NETDEV_PLAY_STATUS_QUARTER_BACKWARD)) {
            value+=2;
        }
        PlaySpeed.setValue(value);
         bRet = NetDemo.netdevsdk.NETDEV_PlayBackControl(NetDemo.lpPlayHandle, NETDEV_VOD_PLAY_CTRL_E.NETDEV_PLAY_CTRL_SETPLAYSPEED, PlaySpeed);
        if(!bRet){
            System.out.println("Set playback speed failed:" + value);
        }
        else{
            NetDemo.lblPlaybackSpeed.setText(Common.PlaybackSpeedToLong((int)value));
            System.out.println("Set playback speed success:" + value);
        }
        if(NETDEV_VOD_PLAY_CTRL_E.NETDEV_PLAY_CTRL_PAUSE == NetDemo.PlayBackControlCmd) {
            NetDemo.jButtonPauseOrResume.doClick();
        }
    }

}
