package main.java.com.netdevsdk.demo.ptz.ptzextend;

import javax.swing.JOptionPane;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.demo.util.Common;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_PTZ_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_PTZ_TRACK_INFO_S;
/**
 * 
 * @description Path cruise includes recording cruise path,acquiring cruise path,starting cruise and stopping cruise
 * @introduction Support IPC/NVR
 */
public class RoutePatrols {
    /**
     * @introduction Acquiring cruise path.
     * @description Call the interface of NETDEV_PTZGetTrackCruise to acquire the cruise path.
     */
    public static void getRoutePatrols() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }

        if(NetDemo.ChannelID == 0)
        {
            JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
            return;
        }

        NETDEV_PTZ_TRACK_INFO_S stTrackCruiseInfo = new NETDEV_PTZ_TRACK_INFO_S();

        boolean bRet = NetDemo.netdevsdk.NETDEV_PTZGetTrackCruise(NetDemo.lpUserID, NetDemo.ChannelID, stTrackCruiseInfo);
        if(bRet != true)
        {
            JOptionPane.showMessageDialog(null, "PTZGetTrackCruise failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            System.out.printf("NETDEV_PTZGetTrackCruise failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        else 
        {
            NetDemo.jTextFieldPTZExtendRoutePatrolsName.setText(Common.byteArrayToString(stTrackCruiseInfo.aszTrackName));
        }
    }
    /**
     * @introduction To start the cruise.
     * @description  Call the interface of NETDEV_PTZGetTrackCruise and NETDEV_PTZTrackCruise to start the cruise.
     */
    public static void runRoutePatrols() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }

        if(NetDemo.ChannelID == 0)
        {
            JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
            return;
        }

        NETDEV_PTZ_TRACK_INFO_S stTrackCruiseInfo = new NETDEV_PTZ_TRACK_INFO_S();

        boolean bRet = NetDemo.netdevsdk.NETDEV_PTZGetTrackCruise(NetDemo.lpUserID, NetDemo.ChannelID, stTrackCruiseInfo);
        if(bRet != true)
        {
            JOptionPane.showMessageDialog(null, "The interface failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            System.out.printf("NETDEV_PTZGetTrackCruise failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }

        bRet = NetDemo.netdevsdk.NETDEV_PTZTrackCruise(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_PTZ_E.NETDEV_PTZ_TRACKCRUISE, Common.byteArrayToString(stTrackCruiseInfo.aszTrackName));
        if(bRet != true)
        {
            JOptionPane.showMessageDialog(null, "The interface failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            System.out.printf("NETDEV_PTZTrackCruise failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }

    }
    /**
     * @introduction To stop the cruise.
     * @description  Call the interface of NETDEV_PTZGetTrackCruise and NETDEV_PTZTrackCruise to stop the cruise.
     */
    public static void stopRoutePatrols() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+ NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }

        if(NetDemo.ChannelID == 0)
        {
            JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
            return;
        }

        NETDEV_PTZ_TRACK_INFO_S stTrackCruiseInfo = new NETDEV_PTZ_TRACK_INFO_S();

        boolean bRet = NetDemo.netdevsdk.NETDEV_PTZGetTrackCruise(NetDemo.lpUserID, NetDemo.ChannelID, stTrackCruiseInfo);
        if(bRet != true)
        {
            JOptionPane.showMessageDialog(null, "The interface failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            System.out.printf("NETDEV_PTZGetTrackCruise failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }

        bRet = NetDemo.netdevsdk.NETDEV_PTZTrackCruise(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_PTZ_E.NETDEV_PTZ_TRACKCRUISESTOP, Common.byteArrayToString(stTrackCruiseInfo.aszTrackName));
        if(bRet != true)
        {
            JOptionPane.showMessageDialog(null, "The interface failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            System.out.printf("NETDEV_PTZTrackCruise failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
    }
    /**
     * @introduction To start to record the cruise path.
     * @description  Call the interface of NETDEV_PTZGetTrackCruise and NETDEV_PTZTrackCruise to record the cruise path.
     */
    public static void startRecordRoute() {
        
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+ NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }

        if(NetDemo.ChannelID == 0)
        {
            JOptionPane.showMessageDialog(null, "Please select an online channel.");
            return;
        }
        NetDemo.jButtonPTZExtendRouteRecordStop.doClick();
        NETDEV_PTZ_TRACK_INFO_S stTrackCruiseInfo = new NETDEV_PTZ_TRACK_INFO_S();
        boolean bRet =  NetDemo.netdevsdk.NETDEV_PTZGetTrackCruise( NetDemo.lpUserID,  NetDemo.ChannelID, stTrackCruiseInfo);
        if(bRet != true)
        {
            JOptionPane.showMessageDialog(null, "The interface failed,error code"+ NetDemo.netdevsdk.NETDEV_GetLastError());
            System.out.printf("NETDEV_PTZGetTrackCruise failed:%d\n",  NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }

        if(stTrackCruiseInfo.dwTrackNum == 0)
        {
            /* Use PTZ to record route */
            boolean bRet2 =  NetDemo.netdevsdk.NETDEV_PTZTrackCruise( NetDemo.lpUserID,  NetDemo.ChannelID, NETDEV_PTZ_E.NETDEV_PTZ_TRACKCRUISEADD, Common.byteArrayToString(stTrackCruiseInfo.aszTrackName));
            if(bRet2 != true)
            {
                JOptionPane.showMessageDialog(null, "The interface failed,error code"+ NetDemo.netdevsdk.NETDEV_GetLastError());
                System.out.printf("NETDEV_PTZTrackCruise failed:%d\n",  NetDemo.netdevsdk.NETDEV_GetLastError());
                return;
            }

            stTrackCruiseInfo.dwTrackNum++;
        }


       boolean bRet1 =  NetDemo.netdevsdk.NETDEV_PTZTrackCruise( NetDemo.lpUserID,  NetDemo.ChannelID, NETDEV_PTZ_E.NETDEV_PTZ_TRACKCRUISEREC, Common.byteArrayToString(stTrackCruiseInfo.aszTrackName));
        if(bRet1 != true)
        {
            JOptionPane.showMessageDialog(null, "The interface failed,error code"+ NetDemo.netdevsdk.NETDEV_GetLastError());
            System.out.printf("NETDEV_PTZTrackCruise failed:%d\n",  NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
    }
    
    /**
     * @introduction To stop to record the cruise path.
     * @description Call the interface of NETDEV_PTZGetTrackCruise and NETDEV_PTZTrackCruise to  stop recording the cruise path.
     */
    public static void stopRecordRoute() {
        if(null ==  NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+ NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }

        if( NetDemo.ChannelID == 0)
        {
            JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
            return;
        }

        NETDEV_PTZ_TRACK_INFO_S stTrackCruiseInfo = new NETDEV_PTZ_TRACK_INFO_S();

        boolean bRet =  NetDemo.netdevsdk.NETDEV_PTZGetTrackCruise( NetDemo.lpUserID,  NetDemo.ChannelID, stTrackCruiseInfo);
        if(false == bRet)
        {
            JOptionPane.showMessageDialog(null, "The interface failed,error code"+ NetDemo.netdevsdk.NETDEV_GetLastError());
            System.out.printf("NETDEV_PTZGetTrackCruise failed:%d\n",  NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }

        bRet =  NetDemo.netdevsdk.NETDEV_PTZTrackCruise( NetDemo.lpUserID,  NetDemo.ChannelID, NETDEV_PTZ_E.NETDEV_PTZ_TRACKCRUISERECSTOP, Common.byteArrayToString(stTrackCruiseInfo.aszTrackName));
        if(false == bRet)
        {
            JOptionPane.showMessageDialog(null, "The interface failed,error code"+ NetDemo.netdevsdk.NETDEV_GetLastError());
            System.out.printf("NETDEV_PTZTrackCruise failed:%d\n",  NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
    }
}
