package main.java.com.netdevsdk.demo.vca.face;

import java.util.Vector;

import javax.swing.JOptionPane;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.demo.util.Common;
import main.java.com.netdevsdk.demo.vca.face.PersonMonitor.PERSON_MONITOR_OPERATE_WINDOW_EFFECT;
import main.java.com.netdevsdk.lib.NetDEVSDKLib;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_DEVICE_TYPE_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_LINKAGE_STRATEGY_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_MONITION_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_MONITION_RULE_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_MONITOR_QUERY_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_VIDEO_DAY_PLAN_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_VIDEO_WEEK_PLAN_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_BATCH_OPERATOR_LIST_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_BATCH_OPERATOR_INFO_S;
/**
 * @description This section can add delete modify and find monitor information.
 * @introduction Support IPC/VMS.
 */
public class PersonMonitorFunction {
    /**
     * @description To add person monitor.
     * @introduction It is mainly realized by the constructor of PersonMonitor.
     */
    public static void addPersonMonitor() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        if(NetDemo.ChannelID == 0)
        {
            JOptionPane.showMessageDialog(null, "Please select an online channel.");
            return;
        }
        PersonMonitor p=new PersonMonitor(PERSON_MONITOR_OPERATE_WINDOW_EFFECT.PERSON_MONITOR_OPERATE_WINDOW_ADDPERSONMONITOR,NetDemo.jButtonFindPersonLib,NetDemo.jButtonFindPersonMonitor,null);
        p.setVisible(true);
     }
    /**
     * @description To delete the person monitor.
     * @introduction Calling  the interface of NETDEV_DeletePersonMonitorInfo to realize. 
     */
    public static void deletePersonMonitor() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        if(0 == NetDemo.PersonMonitorTable.getRowCount() || NetDemo.PersonMonitorTable.getSelectedRow() < 0)
        {
            JOptionPane.showMessageDialog(null, "Please find monitor first");
            return;
        }

        if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC || 
            NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_FISHEYE ||
                NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_ECONOMIC_FISHEYE ||
                    NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_ACS
            ) {
            String strPersonMonitorName = (String) NetDemo.PersonMonitorTable.getValueAt(NetDemo.PersonMonitorTable.getSelectedRow(), 0);
            NETDEV_MONITION_INFO_S stPersonMonitorInfo = NetDemo.mapPersonMonitorMap.get(strPersonMonitorName);
            stPersonMonitorInfo.read();
            int udwId=stPersonMonitorInfo.udwID;
            boolean bRet = NetDemo.netdevsdk.NETDEV_DeletePersonMonitorInfo(NetDemo.lpUserID, udwId);
            if(!bRet)
            {
                System.out.printf("NETDEV_DeletePersonMonitorInfo failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                return;
            }else {
                JOptionPane.showMessageDialog(null, " Delete success");
                NetDemo.jButtonFindPersonMonitor.doClick();
            }
        }else {
            String strPersonMonitorName = (String) NetDemo.PersonMonitorTable.getValueAt(NetDemo.PersonMonitorTable.getSelectedRow(), 0);
            NETDEV_MONITION_INFO_S stPersonMonitorInfo = NetDemo.mapPersonMonitorMap.get(strPersonMonitorName);

            NETDEV_BATCH_OPERATOR_LIST_S stResultList = new NETDEV_BATCH_OPERATOR_LIST_S();
            stResultList.udwNum = 1;
            NETDEV_BATCH_OPERATOR_INFO_S stBatchList = new NETDEV_BATCH_OPERATOR_INFO_S();
            stBatchList.udwID = stPersonMonitorInfo.udwID;
            stBatchList.write();
            stResultList.pstBatchList = stBatchList.getPointer();

            boolean bRet = NetDemo.netdevsdk.NETDEV_BatchDeletePersonMonitorInfo(NetDemo.lpUserID, stResultList);
            if(false == bRet)
            {
                JOptionPane.showMessageDialog(null, "NETDEV_BatchDeletePersonMonitorInfo failed,error code"+  NetDemo.netdevsdk.NETDEV_GetLastError());
                System.out.printf("NETDEV_BatchDeletePersonMonitorInfo failed:%d\n",  NetDemo.netdevsdk.NETDEV_GetLastError());
                return;
            }else {
                JOptionPane.showMessageDialog(null, " Delete success");
                NetDemo.jButtonFindPersonMonitor.doClick();
            }
        }
    }
    /**
     * @description To find person monitor.
     * @introduction Calling the interface of NETDEV_FindPersonMonitorList to realize.
     */
    public static void findPersonMonitor() {
        if(null ==  NetDemo.lpUserID){
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }

        if( NetDemo.ChannelID == 0){
            JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
            return;
        }
        NetDemo.mapPersonMonitorMap.clear();
        NetDemo.PersonMonitorTableModel.setRowCount(0);

        boolean bRet = false;
        NETDEV_MONITOR_QUERY_INFO_S stQueryInfo = new NETDEV_MONITOR_QUERY_INFO_S();
        stQueryInfo.udwLimit = 20;
        Pointer lpPersonMonitorHandle = NetDemo.netdevsdk.NETDEV_FindPersonMonitorList(NetDemo.lpUserID, NetDemo.ChannelID, stQueryInfo);
        if(lpPersonMonitorHandle == null)
        {
            System.out.printf("NETDEV_FindPersonMonitorList failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        else
        {
            while(true)
            {
                NETDEV_MONITION_INFO_S stMonitorInfo = new NETDEV_MONITION_INFO_S();
                stMonitorInfo.stMonitorRuleInfo = new NETDEV_MONITION_RULE_INFO_S();

                stMonitorInfo.stMonitorRuleInfo.udwChannelNum = 1;
                stMonitorInfo.stMonitorRuleInfo.pudwMonitorChlIDList = new Memory(4 * stMonitorInfo.stMonitorRuleInfo.udwChannelNum);
                stMonitorInfo.stMonitorRuleInfo.pudwMonitorChlIDList.setInt(0, 0);

                stMonitorInfo.udwLinkStrategyNum = 10;
                NETDEV_LINKAGE_STRATEGY_S stLinkStrategyList = new NETDEV_LINKAGE_STRATEGY_S();

                stMonitorInfo.pstLinkStrategyList = new Memory(stLinkStrategyList.size() * 10);



                stMonitorInfo.stWeekPlan = new NETDEV_VIDEO_WEEK_PLAN_S();
                for(int i =0; i < NetDEVSDKLib.NETDEV_MAX_DAY_NUM; i++)
                {
                    stMonitorInfo.stWeekPlan.astDayPlan[i] = new NETDEV_VIDEO_DAY_PLAN_S();
                }
                stMonitorInfo.write();

                bRet = NetDemo.netdevsdk.NETDEV_FindNextPersonMonitorInfo(lpPersonMonitorHandle, stMonitorInfo);
                if(bRet != true)
                {
                    System.out.printf("NETDEV_FindNextPersonMonitorInfo failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                    break;
                }
                else
                {
                    //显示查询数据
                    Vector<String> PersonMonitorVector = new Vector<String>();
                    PersonMonitorVector.add(Common.byteArrayToString(stMonitorInfo.stMonitorRuleInfo.szName));
                    PersonMonitorVector.add(Common.byteArrayToString(stMonitorInfo.stMonitorRuleInfo.szReason));
                    if(stMonitorInfo.stMonitorRuleInfo.bEnabled == 1)
                    {
                        PersonMonitorVector.add("enable");
                    }
                    else
                    {
                        PersonMonitorVector.add("disable");
                    }
                    NetDemo.PersonMonitorTableModel.addRow(PersonMonitorVector);
                    NetDemo.mapPersonMonitorMap.put(Common.byteArrayToString(stMonitorInfo.stMonitorRuleInfo.szName), stMonitorInfo);
                }
            }
            bRet = NetDemo.netdevsdk.NETDEV_FindClosePersonMonitorList(lpPersonMonitorHandle);
            if(bRet != true)
            {
                System.out.printf("NETDEV_FindClosePersonMonitorList failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                return;
            }
        }
    }
    /**
     * @description To open the person monitor.
     * @introduction Calling the interface of NETDEV_GetPersonMonitorRuleInfo to realize.
     */
    public static void enablePersonMonitor() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        
        if(0 == NetDemo.PersonMonitorTable.getRowCount() || NetDemo.PersonMonitorTable.getSelectedRow() < 0)
        {
            JOptionPane.showMessageDialog(null, "Please find monitor first");
            return;
        }

        String strPersonMonitorName = (String) NetDemo.PersonMonitorTable.getValueAt(NetDemo.PersonMonitorTable.getSelectedRow(), 0);
        NETDEV_MONITION_INFO_S stPersonMonitorInfo = NetDemo.mapPersonMonitorMap.get(strPersonMonitorName);//布控任务信息 结构体
        boolean bRet = NetDemo.netdevsdk.NETDEV_GetPersonMonitorRuleInfo(NetDemo.lpUserID, stPersonMonitorInfo);//查询单个人脸布控任务配置信息
        if(false == bRet)
        {
                if(NetDemo.netdevsdk.NETDEV_GetLastError()!=130) {//
                    System.out.printf("NETDEV_GetPersonMonitorRuleInfo failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                    return;
                }else {
                    stPersonMonitorInfo.read();
                    stPersonMonitorInfo.write();
                    bRet = NetDemo.netdevsdk.NETDEV_GetPersonMonitorRuleInfo(NetDemo.lpUserID, stPersonMonitorInfo);
                    if(bRet) {
                        stPersonMonitorInfo.read();
                        stPersonMonitorInfo.stMonitorRuleInfo.bEnabled = 1;
                        
                        if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_NVR||
                                NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_HNVR||
                                NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_NVR_BACKUP
                            ) {
                            stPersonMonitorInfo.udwLinkStrategyNum=0;
                            stPersonMonitorInfo.write();
                        }else {
                            stPersonMonitorInfo.write();
                        }
                        bRet = NetDemo.netdevsdk.NETDEV_SetPersonMonitorRuleInfo(NetDemo.lpUserID, stPersonMonitorInfo);
                        if(false == bRet)
                        {
                            JOptionPane.showMessageDialog(null, "NETDEV_SetPersonMonitorRuleInfo failed,error code"+ NetDemo.netdevsdk.NETDEV_GetLastError());
                            System.out.printf("NETDEV_SetPersonMonitorRuleInfo failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                        
                            return;
                        }else {
                            JOptionPane.showMessageDialog(null, "set success");
                            NetDemo.jButtonFindPersonMonitor.doClick(); 
                        }
                    }
                }
                
        }else {
            stPersonMonitorInfo.read();
            stPersonMonitorInfo.stMonitorRuleInfo.bEnabled = 1;
            
            if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_NVR||
                    NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_HNVR||
                    NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_NVR_BACKUP
                ) {//NVR
                stPersonMonitorInfo.udwLinkStrategyNum=0;
                stPersonMonitorInfo.write();
            }else {
                stPersonMonitorInfo.write();
            }
            bRet = NetDemo.netdevsdk.NETDEV_SetPersonMonitorRuleInfo(NetDemo.lpUserID, stPersonMonitorInfo);////设置单个人脸布控任务配置信息
            if(false == bRet)
            {
                JOptionPane.showMessageDialog(null, "NETDEV_SetPersonMonitorRuleInfo failed,error code"+ NetDemo.netdevsdk.NETDEV_GetLastError());
                System.out.printf("NETDEV_SetPersonMonitorRuleInfo failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            
                return;
            }else {
                JOptionPane.showMessageDialog(null, "Set success");
                NetDemo.jButtonFindPersonMonitor.doClick(); 
            }
        }
    }
    
    /**
     * @description To shut down the person monitor.
     * @introduction Calling the interface of NETDEV_GetPersonMonitorRuleInfo and NETDEV_SetPersonMonitorRuleInfo to realize.
     */
    public static void disablePersonMonitor() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        
        if(0 == NetDemo.PersonMonitorTable.getRowCount() || NetDemo.PersonMonitorTable.getSelectedRow() < 0)
        {
            JOptionPane.showMessageDialog(null, "Please find monitor first");
            return;
        }

        String strPersonMonitorName = (String) NetDemo.PersonMonitorTable.getValueAt(NetDemo.PersonMonitorTable.getSelectedRow(), 0);
        NETDEV_MONITION_INFO_S stPersonMonitorInfo = NetDemo.mapPersonMonitorMap.get(strPersonMonitorName);
        boolean bRet = NetDemo.netdevsdk.NETDEV_GetPersonMonitorRuleInfo(NetDemo.lpUserID, stPersonMonitorInfo);
        if(false == bRet)
        {
            if(NetDemo.netdevsdk.NETDEV_GetLastError()!=130) {
                System.out.printf("NETDEV_GetPersonMonitorRuleInfo failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                return;
            }else {
                stPersonMonitorInfo.read();
                stPersonMonitorInfo.write();
                bRet = NetDemo.netdevsdk.NETDEV_GetPersonMonitorRuleInfo(NetDemo.lpUserID, stPersonMonitorInfo);
                if(bRet) {
                    stPersonMonitorInfo.read();
                    stPersonMonitorInfo.stMonitorRuleInfo.bEnabled = 0;
                    if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_NVR||
                            NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_HNVR||
                            NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_NVR_BACKUP
                        ) {
                        stPersonMonitorInfo.udwLinkStrategyNum=0;
                        stPersonMonitorInfo.write();
                    }else {
                        stPersonMonitorInfo.write();
                    }
                    stPersonMonitorInfo.write();
                    bRet = NetDemo.netdevsdk.NETDEV_SetPersonMonitorRuleInfo(NetDemo.lpUserID, stPersonMonitorInfo);
                    if(false == bRet)
                    {
                        JOptionPane.showMessageDialog(null, "NETDEV_SetPersonMonitorRuleInfo failed,error code"+ NetDemo.netdevsdk.NETDEV_GetLastError());
                        System.out.printf("NETDEV_SetPersonMonitorRuleInfo failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                        return;
                    }else {
                        JOptionPane.showMessageDialog(null, "Set success");
                        NetDemo.jButtonFindPersonMonitor.doClick();
                    }
                }
            }
            
        }else {
            stPersonMonitorInfo.read();
            stPersonMonitorInfo.stMonitorRuleInfo.bEnabled = 0;
            if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_NVR||
                    NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_HNVR||
                    NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_NVR_BACKUP
                ) {
                stPersonMonitorInfo.udwLinkStrategyNum=0;
                stPersonMonitorInfo.write();
            }else {
                stPersonMonitorInfo.write();
            }
            stPersonMonitorInfo.write();
            bRet = NetDemo.netdevsdk.NETDEV_SetPersonMonitorRuleInfo(NetDemo.lpUserID, stPersonMonitorInfo);
            if(false == bRet)
            {
                JOptionPane.showMessageDialog(null, "NETDEV_SetPersonMonitorRuleInfo failed,error code"+ NetDemo.netdevsdk.NETDEV_GetLastError());
                System.out.printf("NETDEV_SetPersonMonitorRuleInfo failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                return;
            }else {
                JOptionPane.showMessageDialog(null, "Set success");
                NetDemo.jButtonFindPersonMonitor.doClick();
            }
        }
    }
   /**
    * @introduction To modify person monitor.
    * @description  It is mainly realized by the constructor of PersonMonitor.
    */
    public static void modifyPersonMonitor() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        
        if(0 == NetDemo.PersonMonitorTable.getRowCount() || NetDemo.PersonMonitorTable.getSelectedRow() < 0)
        {
            JOptionPane.showMessageDialog(null, "Please find monitor first");
            return;
        }
        String strPersonMonitorName = (String) NetDemo.PersonMonitorTable.getValueAt(NetDemo.PersonMonitorTable.getSelectedRow(), 0);
        PersonMonitor PP=new PersonMonitor(PERSON_MONITOR_OPERATE_WINDOW_EFFECT.PERSON_MONITOR_OPERATE_WINDOW_MODIFYPERSONMONITOR,NetDemo.jButtonFindPersonLib,NetDemo.jButtonFindPersonMonitor,strPersonMonitorName);
        PP.setVisible(true);
    }
}
