package main.java.com.netdevsdk.demo.vca.peoplecounting;

import javax.swing.JOptionPane;

import main.java.com.netdevsdk.demo.NetDemo;

/**
 * @description IPC data report includes register and cancel.
 * @introduction Support IPC.
 */
public class IPCPeopleCounting {
    /**
     * @description To register IPC data report.
     * @introduction Calling the interface of NETDEV_SetPassengerFlowStatisticCallBack.
     */
    public static void IPCRegister() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        boolean bRet = NetDemo.netdevsdk.NETDEV_SetPassengerFlowStatisticCallBack(NetDemo.lpUserID, NetDemo.cbPassengerFlowStatisticCallBack, null);
        if(bRet) 
        {
            JOptionPane.showMessageDialog(null, "Register success");
        }
        else 
        {
            JOptionPane.showMessageDialog(null, "Register failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
    }
    /**
     * @description To cancel IPC data report.
     * @introduction Calling the interface of NETDEV_SetPassengerFlowStatisticCallBack.
     */
    public static void IPCCancel() {

        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        
        boolean bRet = NetDemo.netdevsdk.NETDEV_SetPassengerFlowStatisticCallBack(NetDemo.lpUserID, null, null);
        if(bRet) 
        {
            JOptionPane.showMessageDialog(null, "Cancel success");
        }
        else 
        {
            JOptionPane.showMessageDialog(null, "Cancel failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
    }
}
