﻿// CCDLgAddDevice.cpp : 
//

#include "stdafx.h"
#include "NetDemo.h"
#include "DLgAddDeviceChn.h"



// CDLgAddDevice 

IMPLEMENT_DYNAMIC(CDlgAddDeviceChn, CDialog)

CDlgAddDeviceChn::CDlgAddDeviceChn(CWnd* pParent /*=NULL*/)
    : CDialog(CDlgAddDeviceChn::IDD, pParent)
    , m_udwAddType(0)
    , m_udwAddIPAddrType(0)
    , m_udwAddAccessPro(3)
    , m_udwAddPtz(0)
{
    m_dwPort = 80;
}

CDlgAddDeviceChn::CDlgAddDeviceChn(INT32 dwChnID,CWnd* pParent)
: CDialog(CDlgAddDeviceChn::IDD, pParent)
, m_udwAddType(0)
, m_udwAddIPAddrType(0)
, m_udwAddAccessPro(3)
, m_udwAddPtz(0)
{
    m_dwChnID =dwChnID;
    m_dwPort = 80;
}

CDlgAddDeviceChn::~CDlgAddDeviceChn()
{
}

void CDlgAddDeviceChn::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);

    DDX_Text(pDX, IDC_EDIT_IP_DOMAIN_NAME, m_strIP);
    DDX_Text(pDX, IDC_EDIT_PORT, m_dwPort);
    DDX_Text(pDX, IDC_EDIT_NAME, m_strUsername);
    DDX_Text(pDX, IDC_EDIT_PASSWORD, m_strPassword);
    DDX_Control(pDX, IDC_COMBO_ADD_DEVICE_CHN_TYPE, m_oAddType);
    DDX_CBIndex(pDX, IDC_COMBO_ADD_DEVICE_CHN_TYPE, m_udwAddType);

    DDX_Control(pDX, IDC_COMBO_ADD_DEVICE_CHN_IPADDR_TYPE, m_oAddIPAddrType);
    DDX_CBIndex(pDX, IDC_COMBO_ADD_DEVICE_CHN_IPADDR_TYPE, m_udwAddIPAddrType);

    DDX_Control(pDX, IDC_COMBO_ADD_DEVICE_CHN_ACCESSPRO_TYPE, m_oAddAccessPro);
    DDX_CBIndex(pDX, IDC_COMBO_ADD_DEVICE_CHN_ACCESSPRO_TYPE, m_udwAddAccessPro);

    DDX_Control(pDX, IDC_COMBO_ADD_DEVICE_CHN_PTZ_TYPE, m_oAddPtz);
    DDX_CBIndex(pDX, IDC_COMBO_ADD_DEVICE_CHN_PTZ_TYPE, m_udwAddPtz);
}

BOOL CDlgAddDeviceChn::OnInitDialog()
{
    CDialog::OnInitDialog();
    GetDlgItem(IDC_ADD_CHN_SELECT_PROTOCLO)->EnableWindow(FALSE);
    InitCombo();
    return TRUE;
}

BEGIN_MESSAGE_MAP(CDlgAddDeviceChn, CDialog)
    ON_BN_CLICKED(IDC_ADD_DEVICE_CHN, &CDlgAddDeviceChn::OnBnClickedAddDeviceChn)
    ON_BN_CLICKED(IDC_GET_DEVICE_CHN, &CDlgAddDeviceChn::OnBnClickedGetDeviceChn)
    ON_BN_CLICKED(IDC_MODFIY_DEVICE_CHN, &CDlgAddDeviceChn::OnBnClickedModifyDeviceChn)
    ON_BN_CLICKED(IDC_ADD_CHN_SELECT_PROTOCLO, &CDlgAddDeviceChn::OnBnClickedSelectPro)
    ON_BN_CLICKED(IDC_CANCEL, &CDlgAddDeviceChn::OnBnClickedCancel)
    ON_CBN_SELCHANGE(IDC_COMBO_ADD_DEVICE_CHN_ACCESSPRO_TYPE, &CDlgAddDeviceChn::OnCbnSelchangeComboAddDeviceChnAccessproType)
END_MESSAGE_MAP()

void CDlgAddDeviceChn::InitCombo()
{
    m_oAddType.SetCurSel(0);
    m_oAddType.InsertString(0,_T("Domain Name"));
    m_oAddType.InsertString(0,_T("EZDDNS"));
    m_oAddType.InsertString(0,_T("Plug/Play"));
    m_oAddType.InsertString(0,_T("IP"));

    m_oAddIPAddrType.SetCurSel(0);
    m_oAddIPAddrType.InsertString(0,_T("Domain Name "));
    m_oAddIPAddrType.InsertString(0,_T("IPv6"));
    m_oAddIPAddrType.InsertString(0,_T("IPv4"));

    m_oAddAccessPro.SetCurSel(0);
    m_oAddAccessPro.InsertString(0,_T("RTSP/Custom"));
    m_oAddAccessPro.InsertString(0,_T("GB"));
    m_oAddAccessPro.InsertString(0,_T("Private"));
    m_oAddAccessPro.InsertString(0,_T("ONVIF"));

    m_oAddPtz.SetCurSel(0);
    m_oAddPtz.InsertString(0,_T("Need"));
    m_oAddPtz.InsertString(0,_T("Noneed"));
    m_oAddPtz.InsertString(0,_T("Auto"));

    return;
}
void CDlgAddDeviceChn::OnBnClickedAddDeviceChn()
{
    //CDialog::OnOK();
    UpdateData();

    if (m_strUsername.IsEmpty() || m_strPassword.IsEmpty() || m_strIP.IsEmpty())
    {
        return;
    }

    NETDEV_CHANNEL_BASIC_INFO_S stChnBaseInfo = {0};

    stChnBaseInfo.udwAddType = m_udwAddType;
    stChnBaseInfo.udwAddressType = m_udwAddIPAddrType;
    stChnBaseInfo.udwPort = m_dwPort;
    memcpy(stChnBaseInfo.szAddress, m_strIP.GetBuffer(0), NETDEV_IPADDR_STR_MAX_LEN-1);
    memcpy(stChnBaseInfo.szLoginName, m_strUsername.GetBuffer(0), NETDEV_NAME_MAX_LEN-1);
    memcpy(stChnBaseInfo.szPIN, m_strPassword.GetBuffer(0), NETDEV_LEN_256-1);
    /* 自定义协议使用自定义协议ID */
    if (m_udwAddAccessPro == 3 )
    {
        stChnBaseInfo.udwAccessProtocol = m_udwAddAccessCustomPro;
    }
    else
    {
        stChnBaseInfo.udwAccessProtocol = m_udwAddAccessPro+1;
    }
    stChnBaseInfo.udwIsPTZNeeded = m_udwAddPtz;
    stChnBaseInfo.udwNum = 1;
    stChnBaseInfo.audwRemoteIndexList[0] = 1;
    stChnBaseInfo.udwRemoteIndex = 0;

    GetParent()->SendMessage(WM_ADD_DEVICECHN, WPARAM(NETDEMO_LOGTYPE_LOCAL), (LPARAM)&stChnBaseInfo);
}


void CDlgAddDeviceChn::OnBnClickedGetDeviceChn()
{
    //CDialog::OnOK();
    UpdateData();
    if (m_dwChnID == 0)
    {
        return;
    }

    GetParent()->SendMessage(WM_GET_DEVICECHN, WPARAM(NETDEMO_LOGTYPE_LOCAL), (LPARAM)this);
    UpdateData(FALSE);
    return;
}

void CDlgAddDeviceChn::OnBnClickedModifyDeviceChn()
{
    UpdateData();

    if (m_strUsername.IsEmpty() || m_strPassword.IsEmpty() || m_strIP.IsEmpty())
    {
        return;
    }

    NETDEV_CHANNEL_BASIC_INFO_S stChnBaseInfo = {0};

    stChnBaseInfo.udwAddType = m_udwAddType;
    stChnBaseInfo.udwAddressType = m_udwAddIPAddrType;
    stChnBaseInfo.udwPort = 554;
    memcpy(stChnBaseInfo.szAddress, m_strIP.GetBuffer(0), NETDEV_IPADDR_STR_MAX_LEN-1);
    memcpy(stChnBaseInfo.szLoginName, m_strUsername.GetBuffer(0), NETDEV_NAME_MAX_LEN-1);
    memcpy(stChnBaseInfo.szPIN, m_strPassword.GetBuffer(0), NETDEV_LEN_256-1);
    /* 自定义协议使用自定义协议ID */
    if (m_udwAddAccessPro ==3 )
    {
        stChnBaseInfo.udwAccessProtocol = m_udwAddAccessCustomPro;
    }
    else
    {
        stChnBaseInfo.udwAccessProtocol = m_udwAddAccessPro;
    }
    stChnBaseInfo.udwIsPTZNeeded = m_udwAddPtz;
    stChnBaseInfo.udwNum = 1;
    stChnBaseInfo.audwRemoteIndexList[0] = 1;
    stChnBaseInfo.udwRemoteIndex = 0;

    GetParent()->SendMessage(WM_SET_DEVICECHN, WPARAM(NETDEMO_LOGTYPE_LOCAL), (LPARAM)&stChnBaseInfo);
    UpdateData(FALSE);
}




void CDlgAddDeviceChn::OnBnClickedSelectPro()
{
    CDlgSelectPro oDlg;
    oDlg.DoModal();
    m_udwAddAccessCustomPro = atoi(oDlg.m_StrProtocolID.GetBuffer(0));
    return;
}

void CDlgAddDeviceChn::OnBnClickedCancel()
{
    EndDialog(-1);
}

//GetDlgItem(IDC_ADD_CHN_SELECT_PROTOCLO)->EnableWindow(TRUE);

void CDlgAddDeviceChn::OnCbnSelchangeComboAddDeviceChnAccessproType()
{
    UpdateData();
    // TODO: 在此添加控件通知处理程序代码
    if (m_udwAddAccessPro == 3)
    {
        GetDlgItem(IDC_ADD_CHN_SELECT_PROTOCLO)->EnableWindow(TRUE);
    }
    else
    {
        GetDlgItem(IDC_ADD_CHN_SELECT_PROTOCLO)->EnableWindow(FALSE);
    }
}
