// Face.cpp : ʵļ
//

#include "stdafx.h"
#include "NetDemo.h"
#include "Face.h"


// CFace Ի

IMPLEMENT_DYNAMIC(CFace, CDialog)

CFace::CFace(CWnd* pParent /*=NULL*/)
	: CDialog(CFace::IDD, pParent)
{

}

CFace::~CFace()
{
}

void CFace::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_TAB_FACE, m_oTabFace);
}


BEGIN_MESSAGE_MAP(CFace, CDialog)
	ON_NOTIFY(TCN_SELCHANGE, IDC_TAB_FACE, &CFace::OnTcnSelchangeTabVca)
END_MESSAGE_MAP()

typedef enum tabIndexConfig
{
	TAB_INDEX_LIBRARY_MANAGERMENT  = 0,
	TAB_INDEX_MONITORING_TASK = 1,
	TAB_INDEX_REALTIME_MONITORING = 2,
    TAB_INDEX_PERSON_ALARM_RECORD = 3,
    TAB_INDEX_PERSON_PASS_RECORD = 4,
};

// CFace Ϣ
BOOL CFace::OnInitDialog()
{
	CDialog::OnInitDialog();
	CRect rc(0, 0, 0, 0);
	GetParent()->GetClientRect(&rc);
	((CTabCtrl*)GetParent())->AdjustRect(FALSE, &rc);
	MoveWindow(&rc);

	m_oFaceLibraryManagerment.SetType(0);
	m_oMonitoringTask.SetType(0);
	m_oRealtimeMonitoring.SetType(0);

	CString str = "Face Library Managerment";
	m_oTabFace.InsertItem(TAB_INDEX_LIBRARY_MANAGERMENT, str);
	m_oFaceLibraryManagerment.Create(IDD_FACE_LIBRARY_MANAGERMENT,&m_oTabFace);
	m_oFaceLibraryManagerment.ShowWindow(SW_SHOW);

	str = "Monitoring Task";
	m_oTabFace.InsertItem(TAB_INDEX_MONITORING_TASK, str);
	m_oMonitoringTask.Create(IDD_MONITORING_TASK,&m_oTabFace);
	m_oMonitoringTask.ShowWindow(SW_HIDE);

	str = "Realtime Monitoring";
	m_oTabFace.InsertItem(TAB_INDEX_REALTIME_MONITORING, str);
	m_oRealtimeMonitoring.Create(IDD_REALTIME_MONITORING,&m_oTabFace);
	m_oRealtimeMonitoring.ShowWindow(SW_HIDE);

    str = "Person Alarm Record";
    m_oTabFace.InsertItem(TAB_INDEX_PERSON_ALARM_RECORD, str);
    m_oPersonAlarmRecord.Create(IDD_PERSON_ALARM_RECORD,&m_oTabFace);
    m_oPersonAlarmRecord.ShowWindow(SW_HIDE);

    str = "Person Pass Record";
    m_oTabFace.InsertItem(TAB_INDEX_PERSON_PASS_RECORD, str);
    m_oPersonPassRecord.Create(IDD_PERSON_PASS_RECORD,&m_oTabFace);
    m_oPersonPassRecord.ShowWindow(SW_HIDE);

	return TRUE;
}

void CFace::TabWithUpdate(INT32 nTabIndex)
{
	switch(nTabIndex)
	{
	case TAB_INDEX_LIBRARY_MANAGERMENT:
		m_oFaceLibraryManagerment.ShowWindow(SW_SHOW);
		m_oMonitoringTask.ShowWindow(SW_HIDE);
		m_oRealtimeMonitoring.ShowWindow(SW_HIDE);
        m_oPersonAlarmRecord.ShowWindow(SW_HIDE);
        m_oPersonPassRecord.ShowWindow(SW_HIDE);
		break;
	case TAB_INDEX_MONITORING_TASK:
		m_oFaceLibraryManagerment.ShowWindow(SW_HIDE);
		m_oMonitoringTask.ShowWindow(SW_SHOW);
		m_oRealtimeMonitoring.ShowWindow(SW_HIDE);
        m_oPersonAlarmRecord.ShowWindow(SW_HIDE);
        m_oPersonPassRecord.ShowWindow(SW_HIDE);
		break;
	case TAB_INDEX_REALTIME_MONITORING:
		m_oFaceLibraryManagerment.ShowWindow(SW_HIDE);
		m_oMonitoringTask.ShowWindow(SW_HIDE);
		m_oRealtimeMonitoring.ShowWindow(SW_SHOW);
        m_oPersonAlarmRecord.ShowWindow(SW_HIDE);
        m_oPersonPassRecord.ShowWindow(SW_HIDE);
		break;
    case TAB_INDEX_PERSON_ALARM_RECORD:
        m_oFaceLibraryManagerment.ShowWindow(SW_HIDE);
        m_oMonitoringTask.ShowWindow(SW_HIDE);
        m_oRealtimeMonitoring.ShowWindow(SW_HIDE);
        m_oPersonAlarmRecord.ShowWindow(SW_SHOW);
        m_oPersonPassRecord.ShowWindow(SW_HIDE);
        break;
    case TAB_INDEX_PERSON_PASS_RECORD:
        m_oFaceLibraryManagerment.ShowWindow(SW_HIDE);
        m_oMonitoringTask.ShowWindow(SW_HIDE);
        m_oRealtimeMonitoring.ShowWindow(SW_HIDE);
        m_oPersonAlarmRecord.ShowWindow(SW_HIDE);
        m_oPersonPassRecord.ShowWindow(SW_SHOW);
        break;
	default:
		break;
	}
}


void CFace::OnTcnSelchangeTabVca(NMHDR *pNMHDR, LRESULT *pResult)
{
	// TODO: ڴӿؼ֪ͨ
	UpdateData(TRUE);
	TabWithUpdate(m_oTabFace.GetCurSel());

	*pResult = 0;
}
