// PersonMonitor.cpp : ʵļ
//

#include "stdafx.h"
#include "NetDemo.h"
#include "PersonMonitor.h"


// CPersonMonitor Ի

IMPLEMENT_DYNAMIC(CPersonMonitor, CDialog)

CPersonMonitor::CPersonMonitor(CWnd* pParent /*=NULL*/)
	: CDialog(CPersonMonitor::IDD, pParent)
{

}

CPersonMonitor::~CPersonMonitor()
{
}

VOID CPersonMonitor::SetType(INT32 dwType)
{
    m_nType = dwType;
}

VOID CPersonMonitor::AddPersonMonitor()
{
    UpdateData(TRUE);
    LPVOID lpHandle = ga_pMainDlg->GetDevHandle();
    if ((NULL == lpHandle))
    {
        NETDEMO_LOG_ERROR(NULL, "Device Handle : %p", lpHandle);
        return;
    }

    INT32 dwChannelID = ga_pMainDlg->GetChlID();
    if(dwChannelID < 0 )
    {
        return;
    }

    NETDEV_MONITION_INFO_S stMonitorInfo = {0};
    stMonitorInfo.stMonitorRuleInfo.bEnabled = 1;

    MBToUTF8(m_strTaskName.GetBuffer(0), stMonitorInfo.stMonitorRuleInfo.szName, sizeof(stMonitorInfo.stMonitorRuleInfo.szName) - 1);
    MBToUTF8(m_strDescribe.GetBuffer(0), stMonitorInfo.stMonitorRuleInfo.szReason, sizeof(stMonitorInfo.stMonitorRuleInfo.szReason) - 1);
    stMonitorInfo.stMonitorRuleInfo.udwMonitorType = m_dwMonitorType;
    stMonitorInfo.stMonitorRuleInfo.udwLibNum = 1;
    INT32 dwIndex = m_oCBoxLibName.GetCurSel();
    stMonitorInfo.stMonitorRuleInfo.audwLibList[0] = m_oLibInfoVector[dwIndex].udwID;

    stMonitorInfo.stMonitorRuleInfo.udwMultipleValue = 80;

    NETDEV_MONITOR_RESULT_INFO_S stMonitorResultInfo = {0};
    stMonitorResultInfo.udwChannelNum = 1;
    NETDEV_MONITION_CHL_INFO_S stMonitorChlInfos = {0}; 

    stMonitorResultInfo.pstMonitorChlInfos = &stMonitorChlInfos;

    if (NETDEV_DTYPE_VMS == gastLoginDeviceInfo.stNETDEV_LoginInfo.dwDevType)
    {
        stMonitorInfo.stMonitorRuleInfo.udwDevNum = 1;
        for(INT32 i = 0; i < gastLoginDeviceInfo.dwDevNum; i++)
        {
            for(std::vector<NETDEV_DEV_CHN_ENCODE_INFO_S>::iterator iter = gastLoginDeviceInfo.stDevLoginInfo[i].vecChanInfo.begin();iter != gastLoginDeviceInfo.stDevLoginInfo[i].vecChanInfo.end();iter++)
            {
                if(dwChannelID == iter->stChnBaseInfo.dwChannelID)
                {
                    stMonitorInfo.stMonitorRuleInfo.audwMonitorDevIDList[0] = gastLoginDeviceInfo.stDevLoginInfo[i].stDevBasicInfo.dwDevID;
                    break;
                }
            }  
        }
    }
    else
    {
        stMonitorInfo.stMonitorRuleInfo.udwChannelNum = 1;
        stMonitorInfo.stMonitorRuleInfo.pudwMonitorChlIDList = (UINT32*)&dwChannelID;
    }

    BOOL bRet = NETDEV_AddPersonMonitorInfo(lpHandle, &stMonitorInfo, &stMonitorResultInfo);
    if(TRUE != bRet)
    {
        NETDEMO_LOG_ERROR(NULL, "NETDEV_AddPersonMonitorInfo");
        return;
    }
    NETDEMO_LOG_SUCC(NULL, "NETDEV_AddPersonMonitorInfo");
}

VOID CPersonMonitor::ModifyPersonMonitor()
{
    UpdateData(TRUE);

    LPVOID lpHandle = ga_pMainDlg->GetDevHandle();
    if ((NULL == lpHandle))
    {
        NETDEMO_LOG_ERROR(NULL, "Device Handle : %p", lpHandle);
        return;
    }
    BOOL bRet = FALSE;

    if (NETDEV_DTYPE_VMS == gastLoginDeviceInfo.stNETDEV_LoginInfo.dwDevType)
    {
        bRet = NETDEV_GetPersonMonitorRuleInfo(lpHandle, m_pstMotitorVector);
        if(TRUE != bRet)
        {
            NETDEMO_LOG_ERROR(NULL, "NETDEV_GetPersonMonitorRuleInfo");
            return;
        }
    }
    else
    {
        m_pstMotitorVector->udwLinkStrategyNum = 0;
    }

    MBToUTF8(m_strTaskName.GetBuffer(0), m_pstMotitorVector->stMonitorRuleInfo.szName, sizeof(m_pstMotitorVector->stMonitorRuleInfo.szName) - 1);
    MBToUTF8(m_strDescribe.GetBuffer(0), m_pstMotitorVector->stMonitorRuleInfo.szReason, sizeof(m_pstMotitorVector->stMonitorRuleInfo.szReason) - 1);

    bRet = NETDEV_SetPersonMonitorRuleInfo(lpHandle, m_pstMotitorVector);
    if(TRUE != bRet)
    {
        NETDEMO_LOG_ERROR(NULL, "NETDEV_SetPersonMonitorRuleInfo");
        return;
    }
    NETDEMO_LOG_SUCC(NULL, "NETDEV_SetPersonMonitorRuleInfo");
}

VOID CPersonMonitor::FindPersonLibInfo()
{
    BOOL bRet = FALSE;
    LPVOID lpHandle = ga_pMainDlg->GetDevHandle();
    m_oLibInfoVector.clear();
    if ((NULL == lpHandle))
    {
        NETDEMO_LOG_ERROR(NULL, "Device Handle : %p", lpHandle);
        return;
    }
    LPVOID lpPersonLibHandle = NETDEV_FindPersonLibList(lpHandle);
    if(NULL ==lpPersonLibHandle)
    {
        NETDEMO_LOG_ERROR(NULL, "NETDEV_FindPersonLibList");
        return;
    }
    else
    {
        while(TRUE)
        {
            NETDEV_LIB_INFO_S stPersonLibInfo = {0};
            bRet = NETDEV_FindNextPersonLibInfo(lpPersonLibHandle,  &stPersonLibInfo);
            if(TRUE != bRet)
            {
                break;
            }
            else
            {
                m_oLibInfoVector.push_back(stPersonLibInfo);
            }
        }
        NETDEV_FindClosePersonLibList(lpPersonLibHandle);
    }

    INT32 dwLibNum = m_oLibInfoVector.size();
    m_oCBoxLibName.ResetContent();
    for(INT32 i = 0; i<dwLibNum; i++)
    {
        CHAR szTmp[NETDEV_LEN_64] = {0};
        UTF8ToMB(m_oLibInfoVector[i].szName, szTmp, sizeof(szTmp) - 1);
        m_oCBoxLibName.InsertString(i, szTmp);
    }
    m_oCBoxLibName.SetCurSel(0);
}

VOID CPersonMonitor::SetMontiorInfo(LPNETDEV_MONITION_INFO_S pstMotitorVector)
{
    m_pstMotitorVector = pstMotitorVector;
}

VOID CPersonMonitor::ReloadMontiorInfo()
{
    CHAR szTmp[NETDEV_LEN_64] = {0};
    UTF8ToMB(m_pstMotitorVector->stMonitorRuleInfo.szName, szTmp, sizeof(szTmp) - 1);
    m_strTaskName = szTmp;

    if(m_pstMotitorVector->stMonitorRuleInfo.udwMonitorType == 0)
    {
        ((CButton *)GetDlgItem(IDC_RADIO_PERSON_MATCH_ALARM))->SetCheck(TRUE);
    }
    else if(m_pstMotitorVector->stMonitorRuleInfo.udwMonitorType == 0)
    {
        ((CButton *)GetDlgItem(IDC_RADIO_PERSON_NO_MATCH_ALARM))->SetCheck(TRUE);
    }
    else
    {}

    ((CButton *)GetDlgItem(IDC_RADIO_PERSON_LIB))->SetCheck(TRUE);


    UTF8ToMB(m_pstMotitorVector->stMonitorRuleInfo.szReason, szTmp, sizeof(szTmp) - 1);
    m_strDescribe = szTmp;
    UpdateData(FALSE);
}

VOID CPersonMonitor::CleanDialogCache()
{
    m_strTaskName = "";
    m_dwMonitorType = 0;
    m_strDescribe = "";
    m_dwMonitorObject = 0;
    m_oCBoxLibName.Clear();
    UpdateData(FALSE);
}

void CPersonMonitor::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);

     DDX_Text(pDX, IDC_EDIT_PERSON_TASK_NAME, m_strTaskName);

     if(TRUE == ((CButton *)GetDlgItem(IDC_RADIO_PERSON_MATCH_ALARM))->GetCheck())
     {
         m_dwMonitorType = 0;
     }
     else if(TRUE == ((CButton *)GetDlgItem(IDC_RADIO_PERSON_NO_MATCH_ALARM))->GetCheck())
     {
         m_dwMonitorType = 1;
     }

     DDX_Text(pDX, IDC_EDIT_PERSON_DESCRIBE, m_strDescribe);

     if(TRUE == ((CButton *)GetDlgItem(IDC_RADIO_PERSON_LIB))->GetCheck())
     {
         m_dwMonitorObject = 0;
     }
     else if(TRUE == ((CButton *)GetDlgItem(IDC_RADIO_PERSON_FACE))->GetCheck())
     {
         m_dwMonitorObject = 1;
     }

     DDX_Control(pDX, IDC_CMB_PERSON_LIB_LIST, m_oCBoxLibName);
}


BEGIN_MESSAGE_MAP(CPersonMonitor, CDialog)
    ON_BN_CLICKED(IDC_BTN_ADD_PERSON_MONITOR, &CPersonMonitor::OnBnClickedBtnAddPersonMonitor)
END_MESSAGE_MAP()


// CPersonMonitor Ϣ

void CPersonMonitor::OnBnClickedBtnAddPersonMonitor()
{
    // TODO: ڴӿؼ֪ͨ
    if(m_nType == 0)
    {
        AddPersonMonitor();
    }
    else
    {
        ModifyPersonMonitor();
    }
}
