// PersonPassRecord.cpp : ʵļ
//

#include "stdafx.h"
#include "NetDemo.h"
#include "PersonPassRecord.h"


// CPersonPassRecord Ի

IMPLEMENT_DYNAMIC(CPersonPassRecord, CDialog)

#define COL_PERSON_PASS_BIGPICTURE           0
#define COL_PERSON_PASS_SMALLPICTURE         1
#define COL_PERSON_PASS_SOURCE               2
#define COL_PERSON_PASS_ALARM_TMIE           3

CPersonPassRecord::CPersonPassRecord(CWnd* pParent /*=NULL*/)
	: CDialog(CPersonPassRecord::IDD, pParent)
{

}

CPersonPassRecord::~CPersonPassRecord()
{
}

void CPersonPassRecord::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);

    DDX_Control(pDX, IDC_PERSON_PASS_DATA_BEGIN, m_oBeginDate);
    DDX_Control(pDX, IDC_PERSON_PASS_DATA_END, m_oBeginTime);
    DDX_Control(pDX, IDC_PERSON_PASS_TIME_BEGIN, m_oEndDate);
    DDX_Control(pDX, IDC_PERSON_PASS_TIME_END, m_oEndTime);
    DDX_Text(pDX, IDC_EDIT_PERSON_PASS_ALARM_SOURCE, m_strAlarmSource);
    DDX_Control(pDX, IDC_LIST_PERSON_PASS, m_oPersonInfoPassList);
    DDX_Text(pDX, IDC_STATIC_PERSON_PASS_TOTAL_NUMBER, m_strTotalNumber);
    DDX_Text(pDX, IDC_STATIC_PERSON_PASS_CURRENT_NUMBER, m_strCurrentNumber);
}

BOOL CPersonPassRecord::OnInitDialog()
{
    CDialog::OnInitDialog();
    CRect rc(0, 0, 0, 0);
    GetParent()->GetClientRect(&rc);
    ((CTabCtrl*)GetParent())->AdjustRect(FALSE, &rc);
    MoveWindow(&rc);

    InitPersonPassList();

    return TRUE;
}

BOOL CPersonPassRecord::getTimeInfo(INT64& dwBeginTime, INT64& dwEndTime)
{
    CString strBeginTime;
    CString strEndTime;
    CString strTemp;
    GetDlgItem(IDC_PERSON_PASS_DATA_BEGIN)->GetWindowText(strTemp);
    strBeginTime = strTemp;
    GetDlgItem(IDC_PERSON_PASS_DATA_END)->GetWindowText(strTemp);
    strBeginTime += " ";
    strBeginTime += strTemp;
    GetDlgItem(IDC_PERSON_PASS_TIME_BEGIN)->GetWindowText(strTemp);
    strEndTime = strTemp;
    GetDlgItem(IDC_PERSON_PASS_TIME_END)->GetWindowText(strTemp);
    strEndTime += " ";
    strEndTime += strTemp;

    dwBeginTime = GetTick(strBeginTime);
    dwEndTime = GetTick(strEndTime);

    if (difftime(dwBeginTime, dwEndTime) >= 0)
    {
        NETDEMO_LOG_ERROR(NULL, "Start time is greater than end time");
        return FALSE;
    }

    return TRUE;
}

long CPersonPassRecord::GetTick(const CString& strTime)
{
    int nYear, nMonth, nDate, nHour, nMin, nSec;
    int nPos= strTime.Find('/');
    if (nPos != std::string::npos)
    {
        sscanf(strTime, "%d/%d/%d %d:%d:%d", &nYear, &nMonth, &nDate, &nHour, &nMin, &nSec);
    }
    nPos= strTime.Find('-');
    if (nPos != std::string::npos)
    {
        sscanf(strTime, "%d-%d-%d %d:%d:%d", &nYear, &nMonth, &nDate, &nHour, &nMin, &nSec);
    }
    nPos= strTime.Find('.');
    if (nPos != std::string::npos)
    {
        sscanf(strTime, "%d.%d.%d %d:%d:%d", &nYear, &nMonth, &nDate, &nHour, &nMin, &nSec);
    }

    struct tm stm;
    memset(&stm,0,sizeof(stm));
    if (nYear > 1900)
    {
        stm.tm_year = nYear-1900;
    }
    else
    {
        stm.tm_year = 2000 + nYear - 1900;
    }
    stm.tm_mon = nMonth-1;
    stm.tm_mday = nDate;
    stm.tm_hour = nHour;
    stm.tm_min = nMin;
    stm.tm_sec = nSec;

    return mktime(&stm);
}

VOID CPersonPassRecord::SavePicture(CString pszFileName, CHAR *pszBuf, INT32 dwSize)
{
    if(pszBuf == NULL || dwSize <= 0)
    {
        return;
    }
    FILE *fp = fopen(pszFileName, "wb");
    if(fp != NULL)
    {
        fwrite(pszBuf, dwSize, 1, fp);
        fclose(fp);
    } 
}

VOID CPersonPassRecord::InitPersonPassList()
{
    CString str = "Big picture path";
    m_oPersonInfoPassList.InsertColumn(COL_PERSON_PASS_BIGPICTURE, str, LVCFMT_LEFT, 150); 

    str = "Small picture path";
    m_oPersonInfoPassList.InsertColumn(COL_PERSON_PASS_SMALLPICTURE, str, LVCFMT_LEFT, 150); 

    str = "source";
    m_oPersonInfoPassList.InsertColumn(COL_PERSON_PASS_SOURCE, str, LVCFMT_LEFT, 150);

    str = "time";
    m_oPersonInfoPassList.InsertColumn(COL_PERSON_PASS_ALARM_TMIE, str, LVCFMT_LEFT, 100);

    m_oPersonInfoPassList.SetExtendedStyle(m_oPersonInfoPassList.GetExtendedStyle()|LVS_EX_GRIDLINES|LVS_EX_FULLROWSELECT|LVS_EX_SUBITEMIMAGES);
}

VOID CPersonPassRecord::FindPersonPassInfo()
{
    UpdateData(TRUE);

    LPVOID lpDevHandle = ga_pMainDlg->GetDevHandle();
    if (NULL == lpDevHandle)
    {
        return ;
    }

    NETDEV_ALARM_LOG_COND_LIST_S stFindCond = {0};
    stFindCond.dwPageRow = 16;
    stFindCond.dwFirstRow = m_dwCurrentNumber;
    stFindCond.dwCondSize = 0;	

    stFindCond.astCondition[stFindCond.dwCondSize].dwQueryType = NETDEV_QUERYCOND_TIME;
    stFindCond.astCondition[stFindCond.dwCondSize].dwLogicFlag = NETDEV_QUERYCOND_LOGIC_NO_LESS;
    INT64 tBeginTime = 0;
    INT64 tEndTime = 0;
    if (FALSE == getTimeInfo(tBeginTime, tEndTime))
    {
        return ;
    }
    sprintf(stFindCond.astCondition[stFindCond.dwCondSize].szConditionData, "%ld", tBeginTime);
    stFindCond.dwCondSize++;

    stFindCond.astCondition[stFindCond.dwCondSize].dwQueryType = NETDEV_QUERYCOND_TIME;
    stFindCond.astCondition[stFindCond.dwCondSize].dwLogicFlag = NETDEV_QUERYCOND_LOGIC_NO_GREATER;
    sprintf(stFindCond.astCondition[stFindCond.dwCondSize].szConditionData, "%ld", tEndTime);
    stFindCond.dwCondSize++;

    if(!m_strAlarmSource.IsEmpty())
    {
        stFindCond.astCondition[stFindCond.dwCondSize].dwQueryType = NETDEV_QUERYCOND_ALARMSRCNAME;
        stFindCond.astCondition[stFindCond.dwCondSize].dwLogicFlag = NETDEV_QUERYCOND_LOGIC_DIM_QUERY;
        stFindCond.dwCondSize++;
    }

    stFindCond.astCondition[stFindCond.dwCondSize].dwQueryType = NETDEV_QUERYCOND_TIME;
    stFindCond.astCondition[stFindCond.dwCondSize].dwLogicFlag = NETDEV_QUERYCOND_LOGIC_DESC_ORDER;
    stFindCond.dwCondSize++;

    NETDEV_SMART_ALARM_LOG_RESULT_INFO_S  stResultInfo = {0};
    BOOL bRet = FALSE;

    LPVOID lpFindRecordHandlePointer = NETDEV_FindFaceRecordDetailList(lpDevHandle, &stFindCond, &stResultInfo);
    if(lpFindRecordHandlePointer != NULL)
    { 
        m_dwTotalNumber = stResultInfo.udwTotal;
        while(TRUE)
        {
            CString strPath = gstLocalParam.szPictureSavePath;
            strPath += "\\";

            NETDEV_FACE_RECORD_SNAPSHOT_INFO_S stRecordInfo = {0};
            stRecordInfo.stCompareInfo.stMemberInfo.stMemberImageInfo.pcData = new CHAR[1048576];
            stRecordInfo.stCompareInfo.stMemberInfo.stMemberImageInfo.udwSize = 1048576;

            stRecordInfo.stCompareInfo.stMemberInfo.stMemberSemiInfo.pcData = new CHAR[1048576];
            stRecordInfo.stCompareInfo.stMemberInfo.stMemberSemiInfo.udwSize = 1048576;

            stRecordInfo.stCompareInfo.stSnapshotImage.stBigImage.pcData = new CHAR[1048576];
            stRecordInfo.stCompareInfo.stSnapshotImage.stBigImage.udwSize = 1048576;

            stRecordInfo.stCompareInfo.stSnapshotImage.stSmallImage.pcData = new CHAR[1048576];
            stRecordInfo.stCompareInfo.stSnapshotImage.stSmallImage.udwSize = 1048576;

            bRet = NETDEV_FindNextFaceRecordDetail(lpFindRecordHandlePointer, &stRecordInfo);
            if(bRet == TRUE)
            {
                m_oFaceRecordSnapshotInfoVector.push_back(stRecordInfo);
            }
            else 
            {
                break;
            }
        }
        NETDEV_FindCloseFaceRecordDetail(lpFindRecordHandlePointer);
    }
    DisPlayFaceRecordSnapshotInfoVector();
}

VOID CPersonPassRecord::CleanFaceRecordSnapshotInfoVector()
{
    for(int i =0; i < m_oFaceRecordSnapshotInfoVector.size(); i++)
    {
        if(m_oFaceRecordSnapshotInfoVector[i].stCompareInfo.stMemberInfo.stMemberImageInfo.pcData != NULL)
        {
            delete[] m_oFaceRecordSnapshotInfoVector[i].stCompareInfo.stMemberInfo.stMemberImageInfo.pcData;
            m_oFaceRecordSnapshotInfoVector[i].stCompareInfo.stMemberInfo.stMemberImageInfo.pcData = NULL;
        }

        if(m_oFaceRecordSnapshotInfoVector[i].stCompareInfo.stMemberInfo.stMemberSemiInfo.pcData != NULL)
        {
            delete[] m_oFaceRecordSnapshotInfoVector[i].stCompareInfo.stMemberInfo.stMemberSemiInfo.pcData;
            m_oFaceRecordSnapshotInfoVector[i].stCompareInfo.stMemberInfo.stMemberSemiInfo.pcData = NULL;
        }

        if(m_oFaceRecordSnapshotInfoVector[i].stCompareInfo.stSnapshotImage.stBigImage.pcData != NULL)
        {
            delete[] m_oFaceRecordSnapshotInfoVector[i].stCompareInfo.stSnapshotImage.stBigImage.pcData;
            m_oFaceRecordSnapshotInfoVector[i].stCompareInfo.stSnapshotImage.stBigImage.pcData = NULL;
        }

        if(m_oFaceRecordSnapshotInfoVector[i].stCompareInfo.stSnapshotImage.stSmallImage.pcData != NULL)
        {
            delete[] m_oFaceRecordSnapshotInfoVector[i].stCompareInfo.stSnapshotImage.stSmallImage.pcData;
            m_oFaceRecordSnapshotInfoVector[i].stCompareInfo.stSnapshotImage.stSmallImage.pcData = NULL;
        }
    }
    m_oFaceRecordSnapshotInfoVector.clear();
}

VOID CPersonPassRecord::DisPlayFaceRecordSnapshotInfoVector()
{
    m_oPersonInfoPassList.DeleteAllItems();
    UpdateData(TRUE);

    CHAR szBuf[64] = {0};
    CString strFilePath = gstLocalParam.szPictureSavePath + CString("\\");
    
    for(INT32 i =0; i < m_oFaceRecordSnapshotInfoVector.size(); i++)
    {
        CString strAlarmSource = "";
        UTF8ToMB(m_oFaceRecordSnapshotInfoVector[i].szChannelName, szBuf, sizeof(szBuf) - 1);
        strAlarmSource.Format("%s", szBuf);

        CString strPassTime = "";

        strPassTime.Format("%d", m_oFaceRecordSnapshotInfoVector[i].udwPassTime);
        m_oPersonInfoPassList.InsertItem(i, _T(""));

        /* Big picture */
        {
            LPVOID lpDevHandle = ga_pMainDlg->GetDevHandle();
            if (NULL != lpDevHandle)
            {
                CString strFileNameBig = strFilePath + "AlarmSource_" + strAlarmSource + "_PassTime" + strPassTime +"_BigImage.jpg";

                NETDEV_FILE_INFO_S stFileInfo = {0};
                stFileInfo.pcData = new CHAR[1048576];
                stFileInfo.udwSize = 1048576;

                BOOL bRet = NETDEV_GetFaceRecordImageInfo(lpDevHandle, m_oFaceRecordSnapshotInfoVector[i].udwRecordID, 0, &stFileInfo);
                if(bRet == TRUE)
                {
                    SavePicture(strFileNameBig, stFileInfo.pcData, stFileInfo.udwSize);
                }
                delete[] stFileInfo.pcData;
                stFileInfo.pcData = NULL;
                m_oPersonInfoPassList.SetItemText(i, COL_PERSON_PASS_BIGPICTURE, strFileNameBig);
            } 
        }

        /* Small picture */
        {
            CString strFileNameSmall = strFilePath + "AlarmSource_" + strAlarmSource + "_PassTime" + strPassTime + "SmallImage.jpg";
            SavePicture(strFileNameSmall, m_oFaceRecordSnapshotInfoVector[i].stCompareInfo.stSnapshotImage.stSmallImage.pcData, m_oFaceRecordSnapshotInfoVector[i].stCompareInfo.stSnapshotImage.stSmallImage.udwSize);
            m_oPersonInfoPassList.SetItemText(i, COL_PERSON_PASS_SMALLPICTURE, strFileNameSmall);
        }

        /* Alarm source */
        m_oPersonInfoPassList.SetItemText(i, COL_PERSON_PASS_SOURCE, strAlarmSource);

        /* Time */
        m_oPersonInfoPassList.SetItemText(i, COL_PERSON_PASS_ALARM_TMIE, strPassTime);
    }

    m_strTotalNumber.Format("%d", m_dwTotalNumber);
    m_strCurrentNumber.Format("%d", m_dwCurrentNumber+16);
    UpdateData(FALSE);
    CleanFaceRecordSnapshotInfoVector();
}


BEGIN_MESSAGE_MAP(CPersonPassRecord, CDialog)
    ON_BN_CLICKED(IDC_BUTTON1, &CPersonPassRecord::OnBnClickedButton1)
    ON_BN_CLICKED(IDC_BUTTON_PERSON_PASS_PREV, &CPersonPassRecord::OnBnClickedButtonPersonPassPrev)
    ON_BN_CLICKED(IDC_BUTTON_PERSON_PASS_NEXT, &CPersonPassRecord::OnBnClickedButtonPersonPassNext)
END_MESSAGE_MAP()


// CPersonPassRecord Ϣ

void CPersonPassRecord::OnBnClickedButton1()
{
    // TODO: ڴӿؼ֪ͨ
    FindPersonPassInfo();
}

void CPersonPassRecord::OnBnClickedButtonPersonPassPrev()
{
    // TODO: ڴӿؼ֪ͨ
    m_dwCurrentNumber -= 16;
    if(m_dwCurrentNumber < 0)
    {
        NETDEMO_LOG_ERROR(NULL, "Current index less than 0");
        return;
    }
    FindPersonPassInfo();
}

void CPersonPassRecord::OnBnClickedButtonPersonPassNext()
{
    // TODO: ڴӿؼ֪ͨ
    m_dwCurrentNumber += 16;
    if(m_dwCurrentNumber >= m_dwTotalNumber)
    {
        NETDEMO_LOG_ERROR(NULL, "Current index big than total index");
        return;
    }
    FindPersonPassInfo();
}
