// VehicleAlarmRecord.cpp : ʵļ
//

#include "stdafx.h"
#include "NetDemo.h"
#include "VehicleAlarmRecord.h"


// CVehicleAlarmRecord Ի

IMPLEMENT_DYNAMIC(CVehicleAlarmRecord, CDialog)

#define COL_VEHICLE_PLATE_PICTURE           0
#define COL_VEHICLE_CAR_PICTURE             1
#define COL_VEHICLE_PLATE_NUMBER            2
#define COL_VEHICLE_PLATE_COLOR             3
#define COL_VEHICLE_PLATE_TYPE              4
#define COL_VEHICLE_CAR_TYPE                5
#define COL_VEHICLE_CAR_COLOR               6
#define COL_VEHICLE_BAYONET_NAME            7
#define COL_VEHICLE_PASS_TIME               8
#define COL_VEHICLE_MONITOR_REASON          9
#define COL_VEHICLE_SPEED                   10

CVehicleAlarmRecord::CVehicleAlarmRecord(CWnd* pParent /*=NULL*/)
	: CDialog(CVehicleAlarmRecord::IDD, pParent)
{

}

CVehicleAlarmRecord::~CVehicleAlarmRecord()
{
}

VOID CVehicleAlarmRecord::InitDialog()
{
    m_oCBoxMonitorType.InsertString(0, _T("Match"));
    m_oCBoxMonitorType.InsertString(1, _T("Not Match"));
    m_oCBoxMonitorType.SetCurSel(0);

    m_oCBoxPlateColor.InsertString(NETDEV_PLATE_COLOR_BLACK_E, _T("BLACK"));
    m_oCBoxPlateColor.InsertString(NETDEV_PLATE_COLOR_WHITE_E, _T("WHITE"));
    m_oCBoxPlateColor.InsertString(NETDEV_PLATE_COLOR_GRAY_E, _T("GRAY"));
    m_oCBoxPlateColor.InsertString(NETDEV_PLATE_COLOR_RED_E, _T("RED"));
    m_oCBoxPlateColor.InsertString(NETDEV_PLATE_COLOR_BLUE_E, _T("BLUE"));
    m_oCBoxPlateColor.InsertString(NETDEV_PLATE_COLOR_YELLOW_E, _T("YELLOW"));
    m_oCBoxPlateColor.InsertString(NETDEV_PLATE_COLOR_ORANGE_E, _T("ORANGE"));
    m_oCBoxPlateColor.InsertString(NETDEV_PLATE_COLOR_BROWN_E, _T("BROWN"));
    m_oCBoxPlateColor.InsertString(NETDEV_PLATE_COLOR_GREEN_E, _T("GREEN"));
    m_oCBoxPlateColor.InsertString(NETDEV_PLATE_COLOR_PURPLE_E, _T("PURPLE"));
    m_oCBoxPlateColor.InsertString(NETDEV_PLATE_COLOR_CYAN_E, _T("CYAN"));
    m_oCBoxPlateColor.InsertString(NETDEV_PLATE_COLOR_PINK_E, _T("PINK"));
    m_oCBoxPlateColor.InsertString(NETDEV_PLATE_COLOR_TRANSPARENT_E, _T("TRANSPARENT"));
    m_oCBoxPlateColor.InsertString(NETDEV_PLATE_COLOR_SILVERYWHITE_E, _T("SILVERYWHITE"));
    m_oCBoxPlateColor.InsertString(NETDEV_PLATE_COLOR_DARK_E, _T("DARK"));
    m_oCBoxPlateColor.InsertString(NETDEV_PLATE_COLOR_LIGHT_E, _T("LIGHT"));
    m_oCBoxPlateColor.InsertString(NETDEV_PLATE_COLOR_COLOURLESS, _T("COLOURLESS"));
    m_oCBoxPlateColor.InsertString(NETDEV_PLATE_COLOR_YELLOWGREEN, _T("YELLOWGREEN"));
    m_oCBoxPlateColor.InsertString(NETDEV_PLATE_COLOR_GRADUALGREEN, _T("GRADUALGREEN"));
    m_oCBoxPlateColor.InsertString(19, _T("ALL"));
    m_oCBoxPlateColor.SetCurSel(19);

    m_oCBoxCarColor.InsertString(NETDEV_PLATE_COLOR_BLACK_E, _T("BLACK"));
    m_oCBoxCarColor.InsertString(NETDEV_PLATE_COLOR_WHITE_E, _T("WHITE"));
    m_oCBoxCarColor.InsertString(NETDEV_PLATE_COLOR_GRAY_E, _T("GRAY"));
    m_oCBoxCarColor.InsertString(NETDEV_PLATE_COLOR_RED_E, _T("RED"));
    m_oCBoxCarColor.InsertString(NETDEV_PLATE_COLOR_BLUE_E, _T("BLUE"));
    m_oCBoxCarColor.InsertString(NETDEV_PLATE_COLOR_YELLOW_E, _T("YELLOW"));
    m_oCBoxCarColor.InsertString(NETDEV_PLATE_COLOR_ORANGE_E, _T("ORANGE"));
    m_oCBoxCarColor.InsertString(NETDEV_PLATE_COLOR_BROWN_E, _T("BROWN"));
    m_oCBoxCarColor.InsertString(NETDEV_PLATE_COLOR_GREEN_E, _T("GREEN"));
    m_oCBoxCarColor.InsertString(NETDEV_PLATE_COLOR_PURPLE_E, _T("PURPLE"));
    m_oCBoxCarColor.InsertString(NETDEV_PLATE_COLOR_CYAN_E, _T("CYAN"));
    m_oCBoxCarColor.InsertString(NETDEV_PLATE_COLOR_PINK_E, _T("PINK"));
    m_oCBoxCarColor.InsertString(NETDEV_PLATE_COLOR_TRANSPARENT_E, _T("TRANSPARENT"));
    m_oCBoxCarColor.InsertString(NETDEV_PLATE_COLOR_SILVERYWHITE_E, _T("SILVERYWHITE"));
    m_oCBoxCarColor.InsertString(NETDEV_PLATE_COLOR_DARK_E, _T("DARK"));
    m_oCBoxCarColor.InsertString(NETDEV_PLATE_COLOR_LIGHT_E, _T("LIGHT"));
    m_oCBoxCarColor.InsertString(NETDEV_PLATE_COLOR_COLOURLESS, _T("COLOURLESS"));
    m_oCBoxCarColor.InsertString(NETDEV_PLATE_COLOR_YELLOWGREEN, _T("YELLOWGREEN"));
    m_oCBoxCarColor.InsertString(NETDEV_PLATE_COLOR_GRADUALGREEN, _T("GRADUALGREEN"));
    m_oCBoxCarColor.InsertString(19, _T("ALL"));
    m_oCBoxCarColor.SetCurSel(19);

    m_oCBoxMonitorReason.InsertString(NETDEV_PLATE_TYPE_BIG_CAR_E, _T("BIG_CAR"));
    m_oCBoxMonitorReason.InsertString(NETDEV_PLATE_TYPE_MINI_CAR_E, _T("MINI_CAR"));
    m_oCBoxMonitorReason.InsertString(NETDEV_PLATE_TYPE_EMBASSY_CAR_E, _T("EMBASSY_CAR"));
    m_oCBoxMonitorReason.InsertString(NETDEV_PLATE_TYPE_CONSULATE_CAR_E, _T("CONSULATE_CAR"));
    m_oCBoxMonitorReason.InsertString(NETDEV_PLATE_TYPE_OVERSEAS_CAR_E, _T("OVERSEAS_CAR"));
    m_oCBoxMonitorReason.InsertString(NETDEV_PLATE_TYPE_FOREIGN_CAR_E, _T("FOREIGN_CAR"));
    m_oCBoxMonitorReason.InsertString(NETDEV_PLATE_TYPE_COMMON_MOTORBIKE_E, _T("COMMON_MOTORBIKE"));
    m_oCBoxMonitorReason.InsertString(NETDEV_PLATE_TYPE_HANDINESS_MOTORBIKE_E, _T("HANDINESS_MOTORBIKE"));
    m_oCBoxMonitorReason.InsertString(NETDEV_PLATE_TYPE_EMBASSY_MOTORBIKE_E, _T("EMBASSY_MOTORBIKE"));
    m_oCBoxMonitorReason.InsertString(NETDEV_PLATE_TYPE_CONSULATE_MOTORBIKE_E, _T("CONSULATE_MOTORBIKE"));
    m_oCBoxMonitorReason.InsertString(NETDEV_PLATE_TYPE_OVERSEAS_MOTORBIKE_E, _T("OVERSEAS_MOTORBIKE"));
    m_oCBoxMonitorReason.InsertString(NETDEV_PLATE_TYPE_FOREIGN_MOTORBIKE_E, _T("FOREIGN_MOTORBIKE"));
    m_oCBoxMonitorReason.InsertString(NETDEV_PLATE_TYPE_LOW_SPEED_CAR_E, _T("LOW_SPEED_CAR"));
    m_oCBoxMonitorReason.InsertString(NETDEV_PLATE_TYPE_TRACTOR_E, _T("TRACTOR"));
    m_oCBoxMonitorReason.InsertString(NETDEV_PLATE_TYPE_TRAILER_E, _T("TRAILER"));
    m_oCBoxMonitorReason.InsertString(NETDEV_PLATE_TYPE_COACH_CAR_E, _T("COACH_CAR"));
    m_oCBoxMonitorReason.InsertString(NETDEV_PLATE_TYPE_COACH_MOTORBIKE_E, _T("COACH_MOTORBIKE"));
    m_oCBoxMonitorReason.InsertString(NETDEV_PLATE_TYPE_TEMPORARY_ENTRY_CAR_E, _T("TEMPORARY_ENTRY_CAR"));
    m_oCBoxMonitorReason.InsertString(NETDEV_PLATE_TYPE_TEMPORARY_ENTRY_MOTORBIKE_E, _T("TEMPORARY_ENTRY_MOTORBIKE"));
    m_oCBoxMonitorReason.InsertString(NETDEV_PLATE_TYPE_TEMPORARY_DRIVING_E, _T("TEMPORARY_DRIVING"));
    m_oCBoxMonitorReason.InsertString(NETDEV_PLATE_TYPE_POLICE_CAR_E, _T("POLICE_CAR"));
    m_oCBoxMonitorReason.InsertString(NETDEV_PLATE_TYPE_POLICE_MOTORBIKE_E, _T("POLICE_MOTORBIKE"));
    m_oCBoxMonitorReason.InsertString(NETDEV_PLATE_TYPE_AGRICULTURAL_E, _T("AGRICULTURAL"));
    m_oCBoxMonitorReason.InsertString(NETDEV_PLATE_TYPE_HONGKONG_ENTRY_EXIT_E, _T("HONGKONG_ENTRY_EXIT"));
    m_oCBoxMonitorReason.InsertString(NETDEV_PLATE_TYPE_MACAO_ENTRY_EXIT_E, _T("MACAO_ENTRY_EXIT"));
    m_oCBoxMonitorReason.InsertString(NETDEV_PLATE_TYPE_ARMED_POLICE_E, _T("ARMED_POLICE"));
    m_oCBoxMonitorReason.InsertString(NETDEV_PLATE_TYPE_ARMY_E, _T("ARMY"));
    m_oCBoxMonitorReason.InsertString(27, _T("All"));
    m_oCBoxMonitorReason.SetCurSel(27);
}

void CVehicleAlarmRecord::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);

    DDX_Control(pDX, IDC_COMBO_VEHICLE_MONITOR_TYPE, m_oCBoxMonitorType);
    DDX_Control(pDX, IDC_VHIECLE_ALARM_DATA_BEGIN, m_oBeginDate);
    DDX_Control(pDX, IDC_VHIECLE_ALARM_TIME_BEGIN, m_oBeginTime);
    DDX_Control(pDX, IDC_VHIECLE_ALARM_DATA_END, m_oEndDate);
    DDX_Control(pDX, IDC_VHIECLE_ALARM_TIME_END, m_oEndTime);
    DDX_Text(pDX, IDC_EDIT_VEHICLE_BAYONET_NAME, m_strBayonetName);
    DDX_Text(pDX, IDC_EDIT_VEHICLE_PLATE_NUMBER, m_strPlateNumber);
    DDX_Control(pDX, IDC_COMBO_VEHICLE_PLATE_COLOR, m_oCBoxPlateColor);
    DDX_Control(pDX, IDC_COMBO_VEHICLE_CAR_COLOR, m_oCBoxCarColor);
    DDX_Control(pDX, IDC_COMBO_VEHICLE_MONTIOR_REASON, m_oCBoxMonitorReason);
    DDX_Control(pDX, IDC_LIST_VEHICLE_ALARM, m_oVehicleAlarmList);
    DDX_Text(pDX, IDC_STATIC_VEHICLE_ALARM_TOTAL_NUMBER, m_strTotalNumber);
    DDX_Text(pDX, IDC_STATIC_VEHICLE_ALARM_CURRENT_NUMBER, m_strCurrentNumber);
}

BOOL CVehicleAlarmRecord::OnInitDialog()
{
    CDialog::OnInitDialog();
    CRect rc(0, 0, 0, 0);
    GetParent()->GetClientRect(&rc);
    ((CTabCtrl*)GetParent())->AdjustRect(FALSE, &rc);
    MoveWindow(&rc);

    InitDialog();
    InitVehicleAlarmList();

    return TRUE;
}

BOOL CVehicleAlarmRecord::getTimeInfo(INT64& dwBeginTime, INT64& dwEndTime)
{
    CString strBeginTime;
    CString strEndTime;
    CString strTemp;
    GetDlgItem(IDC_VHIECLE_ALARM_DATA_BEGIN)->GetWindowText(strTemp);
    strBeginTime = strTemp;
    GetDlgItem(IDC_VHIECLE_ALARM_TIME_BEGIN)->GetWindowText(strTemp);
    strBeginTime += " ";
    strBeginTime += strTemp;
    GetDlgItem(IDC_VHIECLE_ALARM_DATA_END)->GetWindowText(strTemp);
    strEndTime = strTemp;
    GetDlgItem(IDC_VHIECLE_ALARM_TIME_END)->GetWindowText(strTemp);
    strEndTime += " ";
    strEndTime += strTemp;

    dwBeginTime = GetTick(strBeginTime);
    dwEndTime = GetTick(strEndTime);

    if (difftime(dwBeginTime, dwEndTime) >= 0)
    {
        NETDEMO_LOG_ERROR(NULL, "Start time is greater than end time");
        return FALSE;
    }

    return TRUE;
}

long CVehicleAlarmRecord::GetTick(const CString& strTime)
{
    int nYear, nMonth, nDate, nHour, nMin, nSec;
    int nPos= strTime.Find('/');
    if (nPos != std::string::npos)
    {
        sscanf(strTime, "%d/%d/%d %d:%d:%d", &nYear, &nMonth, &nDate, &nHour, &nMin, &nSec);
    }
    nPos= strTime.Find('-');
    if (nPos != std::string::npos)
    {
        sscanf(strTime, "%d-%d-%d %d:%d:%d", &nYear, &nMonth, &nDate, &nHour, &nMin, &nSec);
    }
    nPos= strTime.Find('.');
    if (nPos != std::string::npos)
    {
        sscanf(strTime, "%d.%d.%d %d:%d:%d", &nYear, &nMonth, &nDate, &nHour, &nMin, &nSec);
    }

    struct tm stm;
    memset(&stm,0,sizeof(stm));
    if (nYear > 1900)
    {
        stm.tm_year = nYear-1900;
    }
    else
    {
        stm.tm_year = 2000 + nYear - 1900;
    }
    stm.tm_mon = nMonth-1;
    stm.tm_mday = nDate;
    stm.tm_hour = nHour;
    stm.tm_min = nMin;
    stm.tm_sec = nSec;

    return mktime(&stm);
}

VOID CVehicleAlarmRecord::SavePicture(CString pszFileName, CHAR *pszBuf, INT32 dwSize)
{
    if(pszBuf == NULL || dwSize <= 0)
    {
        return;
    }
    FILE *fp = fopen(pszFileName, "wb");
    if(fp != NULL)
    {
        fwrite(pszBuf, dwSize, 1, fp);
        fclose(fp);
    } 
}

VOID CVehicleAlarmRecord::InitVehicleAlarmList()
{
    CString str = "Plate picture path";
    m_oVehicleAlarmList.InsertColumn(COL_VEHICLE_PLATE_PICTURE, str, LVCFMT_LEFT, 150); 

    str = "Car picture path";
    m_oVehicleAlarmList.InsertColumn(COL_VEHICLE_CAR_PICTURE, str, LVCFMT_LEFT, 150); 

    str = "Plate number";
    m_oVehicleAlarmList.InsertColumn(COL_VEHICLE_PLATE_NUMBER, str, LVCFMT_LEFT, 150);

    str = "Plate color";
    m_oVehicleAlarmList.InsertColumn(COL_VEHICLE_PLATE_COLOR, str, LVCFMT_LEFT, 100);

    str = "Plate type";
    m_oVehicleAlarmList.InsertColumn(COL_VEHICLE_PLATE_TYPE, str, LVCFMT_LEFT, 100);

    str = "Cat type";
    m_oVehicleAlarmList.InsertColumn(COL_VEHICLE_CAR_TYPE, str, LVCFMT_LEFT, 100);

    str = "Car Color";
    m_oVehicleAlarmList.InsertColumn(COL_VEHICLE_CAR_COLOR, str, LVCFMT_LEFT, 100);

    str = "Bayonet name";
    m_oVehicleAlarmList.InsertColumn(COL_VEHICLE_BAYONET_NAME, str, LVCFMT_LEFT, 100);

    str = "Pass time";
    m_oVehicleAlarmList.InsertColumn(COL_VEHICLE_PASS_TIME, str, LVCFMT_LEFT, 100);

    str = "Monitor reason";
    m_oVehicleAlarmList.InsertColumn(COL_VEHICLE_MONITOR_REASON, str, LVCFMT_LEFT, 100);

    str = "Speed";
    m_oVehicleAlarmList.InsertColumn(COL_VEHICLE_SPEED, str, LVCFMT_LEFT, 100);

    m_oVehicleAlarmList.SetExtendedStyle(m_oVehicleAlarmList.GetExtendedStyle()|LVS_EX_GRIDLINES|LVS_EX_FULLROWSELECT|LVS_EX_SUBITEMIMAGES);
}

VOID CVehicleAlarmRecord::FindVehicleAlarmInfo()
{
    UpdateData(TRUE);

    LPVOID lpDevHandle = ga_pMainDlg->GetDevHandle();
    if (NULL == lpDevHandle)
    {
        return ;
    }

    BOOL bRet = FALSE;
    NETDEV_ALARM_LOG_COND_LIST_S stFindCond = {0};
    NETDEV_SMART_ALARM_LOG_RESULT_INFO_S  stResultInfo = {0};

    stFindCond.dwFirstRow = m_dwCurrentNumber;
    stFindCond.dwPageRow = 20;
    stFindCond.dwCondSize = 5;


    stFindCond.astCondition[0].dwQueryType = NETDEV_QUERYCOND_VEH_DATA_TYPE;
    stFindCond.astCondition[0].dwLogicFlag = NETDEV_QUERYCOND_LOGIC_DIM_QUERY;

    stFindCond.astCondition[1].dwQueryType = NETDEV_QUERYCOND_ALARMTYPE;
    stFindCond.astCondition[1].dwLogicFlag = NETDEV_QUERYCOND_LOGIC_EQUAL;
    if(m_oCBoxMonitorType.GetCurSel() == 0)
    {
        memcpy(stFindCond.astCondition[1].szConditionData, "1022", sizeof(stFindCond.astCondition[1].szConditionData));//NETDEV_ALARM_SMART_VEHICLE_MATCH_LIST
    }
    else if(m_oCBoxMonitorType.GetCurSel() == 1)
    {
        memcpy(stFindCond.astCondition[1].szConditionData, "1024", sizeof(stFindCond.astCondition[1].szConditionData));//NETDEV_ALARM_SMART_VEHICLE_MISMATCH_LIST
    }

    INT64 tBeginTime = 0;
    INT64 tEndTime = 0;
    if (FALSE == getTimeInfo(tBeginTime, tEndTime))
    {
        NETDEMO_LOG_ERROR(NULL, "Please select query time");
        return ;
    }

    stFindCond.astCondition[2].dwQueryType = NETDEV_QUERYCOND_TIME;
    stFindCond.astCondition[2].dwLogicFlag = NETDEV_QUERYCOND_LOGIC_NO_LESS;
    sprintf(stFindCond.astCondition[2].szConditionData, "%ld", tBeginTime);

    stFindCond.astCondition[3].dwQueryType = NETDEV_QUERYCOND_TIME;
    stFindCond.astCondition[3].dwLogicFlag = NETDEV_QUERYCOND_LOGIC_NO_GREATER;
    sprintf(stFindCond.astCondition[3].szConditionData, "%ld", tEndTime);

    stFindCond.astCondition[4].dwQueryType = NETDEV_QUERYCOND_TIME;
    stFindCond.astCondition[4].dwLogicFlag = NETDEV_QUERYCOND_LOGIC_DESC_ORDER;

    if(!m_strBayonetName.IsEmpty())
    {
        stFindCond.astCondition[stFindCond.dwCondSize].dwQueryType = NETDEV_QUERYCOND_CHNNAME;
        stFindCond.astCondition[stFindCond.dwCondSize].dwLogicFlag = NETDEV_QUERYCOND_LOGIC_DIM_QUERY;
        MBToUTF8(m_strBayonetName.GetBuffer(0), stFindCond.astCondition[stFindCond.dwCondSize].szConditionData, sizeof(stFindCond.astCondition[stFindCond.dwCondSize].szConditionData) - 1);

        stFindCond.dwCondSize++;
    }

    if(!m_strPlateNumber.IsEmpty())
    {
        stFindCond.astCondition[stFindCond.dwCondSize].dwQueryType = NETDEV_QUERYCOND_PLATE_NUM;
        stFindCond.astCondition[stFindCond.dwCondSize].dwLogicFlag = NETDEV_QUERYCOND_LOGIC_DIM_QUERY;
        MBToUTF8(m_strPlateNumber.GetBuffer(0), stFindCond.astCondition[stFindCond.dwCondSize].szConditionData, sizeof(stFindCond.astCondition[stFindCond.dwCondSize].szConditionData) - 1);

        stFindCond.dwCondSize++;
    }

    if(m_oCBoxPlateColor.GetCurSel() != 19)
    {
        stFindCond.astCondition[stFindCond.dwCondSize].dwQueryType = NETDEV_QUERYCOND_PLATE_COLOR;
        stFindCond.astCondition[stFindCond.dwCondSize].dwLogicFlag = NETDEV_QUERYCOND_LOGIC_EQUAL;
        itoa(m_oCBoxPlateColor.GetCurSel(), stFindCond.astCondition[stFindCond.dwCondSize].szConditionData, 10);

        stFindCond.dwCondSize++;
    }

    if(m_oCBoxCarColor.GetCurSel() != 19)
    {
        stFindCond.astCondition[stFindCond.dwCondSize].dwQueryType = NETDEV_QUERYCOND_VEHICLE_COLOR;
        stFindCond.astCondition[stFindCond.dwCondSize].dwLogicFlag = NETDEV_QUERYCOND_LOGIC_EQUAL;
        itoa(m_oCBoxCarColor.GetCurSel(), stFindCond.astCondition[stFindCond.dwCondSize].szConditionData, 10);

        stFindCond.dwCondSize++;
    }

    if(m_oCBoxMonitorReason.GetCurSel() != 27)
    {
        stFindCond.astCondition[stFindCond.dwCondSize].dwQueryType = NETDEV_QUERYCOND_MONITOY_REASON;
        stFindCond.astCondition[stFindCond.dwCondSize].dwLogicFlag = NETDEV_QUERYCOND_LOGIC_EQUAL;
        itoa(m_oCBoxMonitorReason.GetCurSel(), stFindCond.astCondition[stFindCond.dwCondSize].szConditionData, 10);

        stFindCond.dwCondSize++;
    }

    LPVOID lpFindVehicleRecordHandlePointer = NETDEV_FindVehicleRecordInfoList(lpDevHandle, &stFindCond, &stResultInfo);
    if(lpFindVehicleRecordHandlePointer != NULL)
    {
        m_dwTotalNumber = stResultInfo.udwTotal;
        while(TRUE)
        {
            NETDEV_VEHICLE_RECORD_INFO_S stRecordInfo = {0};
            stRecordInfo.stPlateImage.udwSize = 1048576;
            stRecordInfo.stPlateImage.pcData = new CHAR[stRecordInfo.stPlateImage.udwSize];

            stRecordInfo.stVehicleImage.udwSize = 1048576;
            stRecordInfo.stVehicleImage.pcData = new CHAR[stRecordInfo.stVehicleImage.udwSize];

            stRecordInfo.stPanoImage.udwSize = 1048576;
            stRecordInfo.stPanoImage.pcData = new CHAR[stRecordInfo.stPanoImage.udwSize];

            bRet = NETDEV_FindNextVehicleRecordInfo(lpFindVehicleRecordHandlePointer, &stRecordInfo);
            if(bRet == true)
            {
                m_oVehicleRecordInfoVector.push_back(stRecordInfo);
            }
            else 
            {
                break;
            }
        }
        NETDEV_FindCloseVehicleRecordList(lpFindVehicleRecordHandlePointer);
    }
    DisPlayVehicleRecordInfoVector();
}

VOID CVehicleAlarmRecord::CleanVehicleRecordInfoVector()
{
    for(int i =0; i < m_oVehicleRecordInfoVector.size(); i++)
    {
        if(m_oVehicleRecordInfoVector[i].stPlateImage.pcData != NULL)
        {
            delete[] m_oVehicleRecordInfoVector[i].stPlateImage.pcData;
            m_oVehicleRecordInfoVector[i].stPlateImage.pcData = NULL;
        }

        if(m_oVehicleRecordInfoVector[i].stVehicleImage.pcData != NULL)
        {
            delete[] m_oVehicleRecordInfoVector[i].stVehicleImage.pcData;
            m_oVehicleRecordInfoVector[i].stVehicleImage.pcData = NULL;
        }

        if(m_oVehicleRecordInfoVector[i].stPanoImage.pcData != NULL)
        {
            delete[] m_oVehicleRecordInfoVector[i].stPanoImage.pcData;
            m_oVehicleRecordInfoVector[i].stPanoImage.pcData = NULL;
        }
    }
    m_oVehicleRecordInfoVector.clear();
}

VOID CVehicleAlarmRecord::DisPlayVehicleRecordInfoVector()
{
    m_oVehicleAlarmList.DeleteAllItems();
    UpdateData(TRUE);
    CString strFilePath = gstLocalParam.szPictureSavePath + CString("\\");

    CHAR szBuf[64] = {0};
    for(INT32 i =0; i < m_oVehicleRecordInfoVector.size(); i++)
    {
        CString strCarNumber = "";
        UTF8ToMB(m_oVehicleRecordInfoVector[i].stPlateAttr.szPlateNo, szBuf, sizeof(szBuf) - 1);
        strCarNumber.Format("%s", szBuf);

        CString strPlateColor = EnumNETDEV_PLATE_COLOR_EConventToString(m_oVehicleRecordInfoVector[i].stPlateAttr.udwColor);
        CString strPlateType = EnumNETDEV_PLATE_TYPE_EConventToString(m_oVehicleRecordInfoVector[i].stPlateAttr.udwType);
        CString strCarType = EnumNETDEV_VEHICLE_TYPE_EConventToString(m_oVehicleRecordInfoVector[i].stVehAttr.udwType);
        CString strCarColor = EnumNETDEV_PLATE_COLOR_EConventToString(m_oVehicleRecordInfoVector[i].stVehAttr.udwColor);

        CString strChannelName = "";
        UTF8ToMB(m_oVehicleRecordInfoVector[i].szChannelName, szBuf, sizeof(szBuf) - 1);
        strChannelName.Format("%s", szBuf);

        CString strPassTime = "";
        strPassTime.Format("%d", m_oVehicleRecordInfoVector[i].udwPassingTime);

        CString strMonitorReason = EnumNETDEV_VEHICLE_MONITOR_TYPE_EConventToString(m_oVehicleRecordInfoVector[i].stMonitorAlarmInfo.udwMonitorReason);

        CString strSpeedValue = "";
        strSpeedValue.Format("%f", m_oVehicleRecordInfoVector[i].stVehAttr.fSpeedValue);
        
        m_oVehicleAlarmList.InsertItem(i, _T(""));

        /* Plate picture */
        {
            CString strFileName = strFilePath + "CarNumber_" + strCarNumber + "_PlateColor" + strPlateColor + "_PlateType" + strPlateType + "_CarType" + strCarType + "_CarColor" + strCarColor + "_ChannelName" + strChannelName + "_PassTime"+strPassTime + "_MonitorReason" + strMonitorReason + "_SpeedValue" + strSpeedValue + "_Plate.jpg";
            SavePicture(strFileName, m_oVehicleRecordInfoVector[i].stPlateImage.pcData, m_oVehicleRecordInfoVector[i].stPlateImage.udwSize);
            m_oVehicleAlarmList.SetItemText(i, COL_VEHICLE_PLATE_PICTURE, strFileName);
        }

        /* Car picture */
        {
            LPVOID lpDevHandle = ga_pMainDlg->GetDevHandle();
            if (NULL != lpDevHandle)
            {
                CString strFileName = strFilePath + "CarNumber_" + strCarNumber + "_PlateColor" + strPlateColor + "_PlateType" + strPlateType + "_CarType" + strCarType + "_CarColor" + strCarColor + "_ChannelName" + strChannelName + "_PassTime"+strPassTime + "_MonitorReason" + strMonitorReason + "_SpeedValue" + strSpeedValue + "_VehiclePanoImage.jpg";
                NETDEV_FILE_INFO_S stFileInfo = {0};
                stFileInfo.udwSize = 1048576;
                stFileInfo.pcData = new CHAR[stFileInfo.udwSize];
                BOOL iRet= NETDEV_GetVehicleRecordImageInfo(lpDevHandle, m_oVehicleRecordInfoVector[i].udwRecordID, &stFileInfo);
                if(iRet == TRUE)
                {
                    SavePicture(strFileName, stFileInfo.pcData, stFileInfo.udwSize);
                    m_oVehicleAlarmList.SetItemText(i, COL_VEHICLE_CAR_PICTURE, strFileName);
                }
                delete[] stFileInfo.pcData;
                stFileInfo.pcData = NULL;
            }
        }

        /* plate number */
        m_oVehicleAlarmList.SetItemText(i, COL_VEHICLE_PLATE_NUMBER, strCarNumber);

        /* plate color */
        m_oVehicleAlarmList.SetItemText(i, COL_VEHICLE_PLATE_COLOR, strPlateColor);

        /* plate type */
        m_oVehicleAlarmList.SetItemText(i, COL_VEHICLE_PLATE_TYPE, strPlateType);

        /* car type */
        m_oVehicleAlarmList.SetItemText(i, COL_VEHICLE_CAR_TYPE, strCarType);

        /* Car color */
        m_oVehicleAlarmList.SetItemText(i, COL_VEHICLE_CAR_COLOR, strCarColor);

        /* Bayonet name */
        m_oVehicleAlarmList.SetItemText(i, COL_VEHICLE_BAYONET_NAME, strChannelName);

        /* pass time */
        m_oVehicleAlarmList.SetItemText(i, COL_VEHICLE_PASS_TIME, strPassTime);

        /* Monitor reason */
        m_oVehicleAlarmList.SetItemText(i, COL_VEHICLE_MONITOR_REASON, strMonitorReason);

        /* Speed */
        m_oVehicleAlarmList.SetItemText(i, COL_VEHICLE_SPEED, strSpeedValue);
    }

    m_strTotalNumber.Format("%d", m_dwTotalNumber);
    m_strCurrentNumber.Format("%d", m_dwCurrentNumber+16);
    UpdateData(FALSE);
    CleanVehicleRecordInfoVector();
}

CString CVehicleAlarmRecord::EnumNETDEV_PLATE_COLOR_EConventToString(INT32 dwEnum)
{
    CString strTempString = "";
    switch (dwEnum) {
        case NETDEV_PLATE_COLOR_BLACK_E:
            strTempString = "BLACK";
            break;
        case NETDEV_PLATE_COLOR_WHITE_E:
            strTempString = "WHITE";
            break;
        case NETDEV_PLATE_COLOR_GRAY_E:
            strTempString = "GRAY";
            break;
        case NETDEV_PLATE_COLOR_RED_E:
            strTempString = "RED";
            break;
        case NETDEV_PLATE_COLOR_BLUE_E:
            strTempString = "BLUE";
            break;
        case NETDEV_PLATE_COLOR_YELLOW_E:
            strTempString = "YELLOW";
            break;
        case NETDEV_PLATE_COLOR_ORANGE_E:
            strTempString = "ORANGE";
            break;
        case NETDEV_PLATE_COLOR_BROWN_E:
            strTempString = "BROWN";
            break;
        case NETDEV_PLATE_COLOR_GREEN_E:
            strTempString = "GREEN";
            break;
        case NETDEV_PLATE_COLOR_PURPLE_E:
            strTempString = "PURPLE";
            break;
        case NETDEV_PLATE_COLOR_CYAN_E:
            strTempString = "CYAN";
            break;
        case NETDEV_PLATE_COLOR_PINK_E:
            strTempString = "PINK";
            break;
        case NETDEV_PLATE_COLOR_TRANSPARENT_E:
            strTempString = "TRANSPARENT";
            break;

        case NETDEV_PLATE_COLOR_SILVERYWHITE_E:
            strTempString = "SILVERYWHITE";
            break;

        case NETDEV_PLATE_COLOR_DARK_E:
            strTempString = "DARK";
            break;

        case NETDEV_PLATE_COLOR_LIGHT_E:
            strTempString = "LIGHT";
            break;

        case NETDEV_PLATE_COLOR_COLOURLESS:
            strTempString = "COLOURLESS";
            break;

        case NETDEV_PLATE_COLOR_YELLOWGREEN:
            strTempString = "YELLOWGREEN";
            break;

        case NETDEV_PLATE_COLOR_GRADUALGREEN:
            strTempString = "GRADUALGREEN";
            break;

        case NETDEV_PLATE_COLOR_OTHER_E:
            strTempString = "OTHER";
            break;

        default:
            strTempString = "OTHER";
            break;
    }

    return strTempString;
}

CString CVehicleAlarmRecord::EnumNETDEV_PLATE_TYPE_EConventToString(INT32 dwEnum)
{
    CString strTempString = "";
    switch (dwEnum) {
        case NETDEV_PLATE_TYPE_BIG_CAR_E:
            strTempString = "BIG_CAR";
            break;
        case NETDEV_PLATE_TYPE_MINI_CAR_E:
            strTempString = "MINI_CAR";
            break;
        case NETDEV_PLATE_TYPE_EMBASSY_CAR_E:
            strTempString = "EMBASSY_CAR";
            break;
        case NETDEV_PLATE_TYPE_CONSULATE_CAR_E:
            strTempString = "CONSULATE_CAR";
            break;
        case NETDEV_PLATE_TYPE_OVERSEAS_CAR_E:
            strTempString = "OVERSEAS_CAR";
            break;
        case NETDEV_PLATE_TYPE_FOREIGN_CAR_E:
            strTempString = "FOREIGN_CAR";
            break;
        case NETDEV_PLATE_TYPE_COMMON_MOTORBIKE_E:
            strTempString = "COMMON_MOTORBIKE";
            break;
        case NETDEV_PLATE_TYPE_HANDINESS_MOTORBIKE_E:
            strTempString = "HANDINESS_MOTORBIKE";
            break;
        case NETDEV_PLATE_TYPE_EMBASSY_MOTORBIKE_E:
            strTempString = "EMBASSY_MOTORBIKE";
            break;
        case NETDEV_PLATE_TYPE_CONSULATE_MOTORBIKE_E:
            strTempString = "CONSULATE_MOTORBIKE";
            break;
        case NETDEV_PLATE_TYPE_OVERSEAS_MOTORBIKE_E:
            strTempString = "OVERSEAS_MOTORBIKE";
            break;
        case NETDEV_PLATE_TYPE_FOREIGN_MOTORBIKE_E:
            strTempString = "FOREIGN_MOTORBIKE";
            break;
        case NETDEV_PLATE_TYPE_LOW_SPEED_CAR_E:
            strTempString = "LOW_SPEED_CAR";
            break;
        case NETDEV_PLATE_TYPE_TRACTOR_E:
            strTempString = "TYPE_TRACTOR";
            break;
        case NETDEV_PLATE_TYPE_TRAILER_E:
            strTempString = "TRAILER";
            break;
        case NETDEV_PLATE_TYPE_COACH_CAR_E:
            strTempString = "COACH_CAR";
            break;
        case NETDEV_PLATE_TYPE_COACH_MOTORBIKE_E:
            strTempString = "COACH_MOTORBIKE";
            break;
        case NETDEV_PLATE_TYPE_TEMPORARY_ENTRY_CAR_E:
            strTempString = "TEMPORARY_ENTRY_CAR";
            break;
        case NETDEV_PLATE_TYPE_TEMPORARY_ENTRY_MOTORBIKE_E:
            strTempString = "TEMPORARY_ENTRY_MOTORBIKE";
            break;
        case NETDEV_PLATE_TYPE_TEMPORARY_DRIVING_E:
            strTempString = "TEMPORARY_DRIVING";
            break;
        case NETDEV_PLATE_TYPE_POLICE_CAR_E:
            strTempString = "POLICE_CAR";
            break;
        case NETDEV_PLATE_TYPE_POLICE_MOTORBIKE_E:
            strTempString = "POLICE_MOTORBIKE";
            break;
        case NETDEV_PLATE_TYPE_AGRICULTURAL_E:
            strTempString = "AGRICULTURAL";
            break;
        case NETDEV_PLATE_TYPE_HONGKONG_ENTRY_EXIT_E:
            strTempString = "HONGKONG_ENTRY_EXIT";
            break;
        case NETDEV_PLATE_TYPE_MACAO_ENTRY_EXIT_E:
            strTempString = "MACAO_ENTRY_EXIT";
            break;
        case NETDEV_PLATE_TYPE_ARMED_POLICE_E:
            strTempString = "ARMED_POLICE";
            break;
        case NETDEV_PLATE_TYPE_ARMY_E:
            strTempString = "ARMY";
            break;

        default:
            strTempString = "OTHER";
            break;
    }

    return strTempString;
}

CString CVehicleAlarmRecord::EnumNETDEV_VEHICLE_TYPE_EConventToString(INT32 dwEnum)
{
    CString strTempString = "";
    switch (dwEnum) {
        case NETDEV_VEHICLE_TYPE_TRICYCLE_E:
            strTempString = "TRICYCLE";
            break;
        case NETDEV_VEHICLE_TYPE_MOTOR_BUS_E:
            strTempString = "MOTOR_BUS";
            break;
        case NETDEV_VEHICLE_TYPE_MIDDLE_E:
            strTempString = "MIDDLE";
            break;
        case NETDEV_VEHICLE_TYPE_SMALL_E:
            strTempString = "SMALL";
            break;
        case NETDEV_VEHICLE_TYPE_BIG_E:
            strTempString = "BIG";
            break;
        case NETDEV_VEHICLE_TYPE_TWOWHEELVEH:
            strTempString = "TWOWHEELVEH";
            break;
        case NETDEV_VEHICLE_TYPE_MOTORCYCLE_E:
            strTempString = "MOTORCYCLE";
            break;
        case NETDEV_VEHICLE_TYPE_TRACTOR_E:
            strTempString = "TRACTOR";
            break;
        case NETDEV_VEHICLE_TYPE_AGRICULTURAL_E:
            strTempString = "AGRICULTURAL";
            break;
        case NETDEV_VEHICLE_TYPE_SEADAN:
            strTempString = "SEADAN";
            break;
        case NETDEV_VEHICLE_TYPE_SUV_E:
            strTempString = "SUV";
            break;
        case NETDEV_VEHICLE_TYPE_VAN_E:
            strTempString = "VAN";
            break;
        case NETDEV_VEHICLE_TYPE_SMALLTRUCK_E:
            strTempString = "SMALLTRUCK";
            break;
        case NETDEV_VEHICLE_TYPE_MEDIUMCAR_E:
            strTempString = "MEDIUMCAR";
            break;
        case NETDEV_VEHICLE_TYPE_LARGEBUS_E:
            strTempString = "LARGEBUS";
            break;
        case NETDEV_VEHICLE_TYPE_LARGETRUCK_E:
            strTempString = "LARGETRUCK";
            break;
        case NETDEV_VEHICLE_TYPE_PICKUPTRUCK_E:
            strTempString = "PICKUPTRUCK";
            break;
        case NETDEV_VEHICLE_TYPE_BUSINESSVEH_E:
            strTempString = "BUSINESSVEH";
            break;
        case NETDEV_VEHICLE_TYPE_SPORTSCAR_E:
            strTempString = "SPORTSCAR";
            break;
        case NETDEV_VEHICLE_TYPE_MINICAR_E:
            strTempString = "MINICAR";
            break;
        case NETDEV_VEHICLE_TYPE_HATCHBACKCAR_E:
            strTempString = "HATCHBACKCAR";
            break;
        case NETDEV_VEHICLE_TYPE_THREEBOX_E:
            strTempString = "THREEBOX";
            break;
        case NETDEV_VEHICLE_TYPE_LIGHTBUS_E:
            strTempString = "LIGHTBUS";
            break;
        case NETDEV_VEHICLE_TYPE_MEDIUNTRUCK_E:
            strTempString = "MEDIUNTRUCK";
            break;
        case NETDEV_VEHICLE_TYPE_TRAILER_E:
            strTempString = "TRAILER";
            break;
        case NETDEV_VEHICLE_TYPE_TANK_E:
            strTempString = "TANK";
            break;
        case NETDEV_VEHICLE_TYPE_WATERCAR_E:
            strTempString = "WATERCAR";
            break;
        case NETDEV_VEHICLE_TYPE_OTHER_E:
            strTempString = "OTHER";
            break;
        default:
            strTempString = "OTHER";
            break;
    }

    return strTempString;
}

CString CVehicleAlarmRecord::EnumNETDEV_VEHICLE_MONITOR_TYPE_EConventToString(INT32 dwEnum)
{
    CString strTempString = "";
    switch (dwEnum) {
        case NETDEV_VEHICLE_MONITOR_TYPE_ROB_E:
            strTempString = "ROB";
            break;
        case NETDEV_VEHICLE_MONITOR_TYPE_STEAL_E:
            strTempString = "STEAL";
            break;
        case NETDEV_VEHICLE_MONITOR_TYPE_SUSPICION_E:
            strTempString = "SUSPICION";
            break;
        case NETDEV_VEHICLE_MONITOR_TYPE_ILLEGAL_E:
            strTempString = "ILLEGAL";
            break;
        case NETDEV_VEHICLE_MONITOR_TYPE_SUREILLANCE_E:
            strTempString = "SUREILLANCE";
            break;
        default:
            strTempString = "OTHER";
            break;
    }

    return strTempString;
}


BEGIN_MESSAGE_MAP(CVehicleAlarmRecord, CDialog)
    ON_BN_CLICKED(IDC_BUTTON_VEHICLE_ALARM_FIND, &CVehicleAlarmRecord::OnBnClickedButtonVehicleAlarmFind)
    ON_BN_CLICKED(IDC_BUTTON_VEHICLE_ALARM_PREV, &CVehicleAlarmRecord::OnBnClickedButtonVehicleAlarmPrev)
    ON_BN_CLICKED(IDC_BUTTON_VEHICLE_ALARM_NEXT, &CVehicleAlarmRecord::OnBnClickedButtonVehicleAlarmNext)
END_MESSAGE_MAP()


// CVehicleAlarmRecord Ϣ

void CVehicleAlarmRecord::OnBnClickedButtonVehicleAlarmFind()
{
    // TODO: ڴӿؼ֪ͨ
    m_dwTotalNumber = 0;
    m_dwCurrentNumber = 0;
    FindVehicleAlarmInfo();
}

void CVehicleAlarmRecord::OnBnClickedButtonVehicleAlarmPrev()
{
    // TODO: ڴӿؼ֪ͨ
    m_dwCurrentNumber -= 16;
    if(m_dwCurrentNumber < 0)
    {
        NETDEMO_LOG_ERROR(NULL, "Current index less than 0");
        return;
    }
    FindVehicleAlarmInfo();
}

void CVehicleAlarmRecord::OnBnClickedButtonVehicleAlarmNext()
{
    // TODO: ڴӿؼ֪ͨ
    m_dwCurrentNumber += 16;
    if(m_dwCurrentNumber >= m_dwTotalNumber)
    {
        NETDEMO_LOG_ERROR(NULL, "Current index big than total index");
        return;
    }
    FindVehicleAlarmInfo();
}
